package com.ejie.aa20b.error;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Message;
import javax.jms.MessageListener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.aa20b.message.Aa20bProcessErrorMessage;

/**
 * Message-Driven Bean implementation class for: Aa20bMDB
 *
 */
@MessageDriven(activationConfig = { @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue") }, name = "aa20bErrorMDB", mappedName = "aa20b.aa20bJMSErrorQueue")
@TransactionManagement(TransactionManagementType.CONTAINER)
@TransactionAttribute()
public class Aa20bErrorMDB implements MessageListener {


    /**
     * Default constructor. 
     */
    public Aa20bErrorMDB() {
        // TODO Auto-generated constructor stub
    }

	
    private static final Logger logger = LoggerFactory
	.getLogger(Aa20bErrorMDB.class);
	
	/**
     * @see MessageListener#onMessage(Message)
     */
    public void onMessage(Message message) {
        // TODO Auto-generated method stub
   		Aa20bErrorMDB.logger.info("@@@@@@@  Llega el mensaje " + message);
   		new Aa20bProcessErrorMessage(message).onMessage();				

    }
    
    
    
}
