package com.ejie.aa20b.ejb;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;


import com.ejie.aa20b.message.Aa20bProcessMessage;
/**
 * Message-Driven Bean implementation class for: Aa20bMDB
 *
 */
@MessageDriven(activationConfig = { @ActivationConfigProperty(propertyName = "destinationType", propertyValue = "javax.jms.Queue") }, name = "aa20bMDB", mappedName = "aa20b.aa20bJMSQueue")
@TransactionManagement(TransactionManagementType.CONTAINER)
@TransactionAttribute()
public class Aa20bMDB implements MessageListener {


    /**
     * Default constructor. 
     */
    public Aa20bMDB() {
        // TODO Auto-generated constructor stub
    }
    
    @Autowired
	private PropertiesFactoryBean appConfiguration;

	private javax.jms.Connection jmsConnection;
    @Resource(mappedName = "aa20b.aa20bJMSErrorQueue")
    private javax.jms.Destination errorQueue;
    @Resource(mappedName = "aa20b.aa20bJMSConnectionFactory")
    private javax.jms.ConnectionFactory connectionFactory;
    
    @PostConstruct
    public void initialize() {
        try {
            jmsConnection = connectionFactory.createConnection();
        } catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }

    @PreDestroy
    public void cleanup() {
        try {
            jmsConnection.close();
        } catch (JMSException jmse) {
            jmse.printStackTrace();
        }
    }
    
    private static final Logger logger = LoggerFactory
	.getLogger(Aa20bMDB.class);
	
	/**
     * @see MessageListener#onMessage(Message)
     */
    public void onMessage(Message message) {
        // TODO Auto-generated method stub
   		Aa20bMDB.logger.info("@@@@@@@  Llega el mensaje " + message);
   		new Aa20bProcessMessage(message,jmsConnection,errorQueue).onMessage();		

    }
    
    /*public void ejbRemove() throws EJBException {
        // TODO Auto-generated method stub

    }*/
    
    /**
     * An ejbCreate method as required by the EJB specification.
     * 
     * The container calls the instance?s <code>ejbCreate</code> method 
     * immediately after instantiation.
     * 
     * @ejb.create-method
     */
    /*public void ejbCreate() {
    }*/
    
}
