package com.ejie.aa20b.util;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;

import org.springframework.context.support.ReloadableResourceBundleMessageSource;

import com.ejie.aa20b.model.PrevAnual;
import com.ejie.aa20b.model.TablaPlanificacion;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Font.FontFamily;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

public class PdfPrevAnualPorEdificios extends PdfBuilder {

	public PdfPrevAnualPorEdificios(
			ReloadableResourceBundleMessageSource appMessageSource,
			Locale locale) {
		super(appMessageSource, locale);

	}

	private String valorEnHoras(Integer minutos) {
		String horas = "";
		String min = "";
		if (minutos != null) {
			horas = (minutos / 60 > 0 ? (minutos / 60) + "h " : "");
			min = (minutos % 60) > 0 ? minutos % 60 + "'" : "";
			return horas + min;
		} else {
			return "";
		}

	}

	@SuppressWarnings("null")
	public void crearListado(ArrayList listaPartes, PrevAnual filterPrevAnual,
			OutputStream out) {
		Document doc = new Document(PageSize.A4.rotate(), 20f, 20f, 70f, 30f);

		PdfWriter docWriter = null;
		doc.setPageSize(PageSize.A4.rotate());
		try {
			docWriter = PdfWriter.getInstance(doc, out);
			doc.addAuthor("agarcibl"); //$NON-NLS-1$
			doc.addCreationDate();
			doc.addProducer();
			doc.addCreator("agarcibl"); //$NON-NLS-1$
			doc.addTitle("Previsto por edificios"); //$NON-NLS-1$

			TableHeader event = new TableHeader();
			docWriter.setPageEvent(event);
			doc.open();
			PdfPCell cell1;

			Font fontCabecera = new Font(FontFamily.HELVETICA, 7, Font.BOLD,
					BaseColor.BLACK);
			Font fontDatos = new Font(FontFamily.HELVETICA, 7, Font.NORMAL,
					BaseColor.BLACK);
			Font fontDatosHoras = new Font(FontFamily.HELVETICA, 5,
					Font.NORMAL, BaseColor.BLACK);
			Font fontTitulo = new Font(FontFamily.HELVETICA, 14, Font.BOLD,
					BaseColor.BLACK);

			float[] columnWidths = new float[] { 4f, 7f, 1f, 1f, 1f, 1f, 1f,
					1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f,
					1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f,
					1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f, 1f,
					1f, 1f, 1f, 1f };

			PdfPTable table = null;
			PdfPTable tableCabecera = null;
			PdfPTable tableFiltros = null;
			PdfPTable tableTitulosCabecera = null;
			// PdfPTable tableTotales = null;

			Boolean esPrimero = true;
			String gama = "";
			String edificio = "";
			String zona = "";
			String planta = "";
			Integer[] arrayTotalGama = null;
			arrayTotalGama = new Integer[54];
			Integer[] arrayTotalEdificio = null;
			arrayTotalEdificio = new Integer[54];
			Integer[] arrayTotalZona = null;
			arrayTotalZona = new Integer[54];
			Integer[] arrayTotalPlanta = null;
			arrayTotalPlanta = new Integer[54];

			// Titulo del informe
			PdfPTable tableTitulo = new PdfPTable(1);
			tableTitulo.setSpacingAfter(5);
			tableTitulo.setSpacingBefore(0);
			tableTitulo.setWidthPercentage(100);
			float[] columnWidthsTitulo = new float[] { 15f };
			try {
				tableTitulo.setWidths(columnWidthsTitulo);
			} catch (DocumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			tableTitulo.setHorizontalAlignment(Element.ALIGN_CENTER);

			PdfPCell cell1_Titulos;
			cell1_Titulos = new PdfPCell(new Paragraph(
					this.appMessageSource.getMessage("prevAnual.prevPorEdif",
							null, locale) + " " + filterPrevAnual.getAnio(),
					fontTitulo));
			cell1_Titulos.setBorder(PdfPCell.NO_BORDER);
			cell1_Titulos.setHorizontalAlignment(Element.ALIGN_CENTER);
			tableTitulo.addCell(cell1_Titulos);

			doc.add(tableTitulo);

			// Creamos la cabecera de los filtros selecionados
			tableFiltros = filtrosPorEdificios(filterPrevAnual);
			doc.add(tableFiltros);

			for (int i = 0; i < listaPartes.size(); i++) {
				TablaPlanificacion laFila = new TablaPlanificacion();
				laFila = (TablaPlanificacion) listaPartes.get(i);

				// Si es una nueva Planta pero dentro de la misma Zona, Edificio
				// y Gama
				if (!planta.equals(laFila.getPlanta().toString())
						&& zona.equals(laFila.getZona().toString())
						&& edificio.equals(laFila.getEdificio().toString())
						&& gama.equals(laFila.getGama().toString())) {
					// Si no es el primero metemos los totales de la planta
					// anterior
					if (!esPrimero) {
						// Añadimos la linea de totales por planta
						cell1 = new PdfPCell(new Paragraph("", fontCabecera));
						table.addCell(cell1);
						cell1 = new PdfPCell(new Paragraph(
								this.appMessageSource.getMessage(
										"prevAnual.totalPlanta", null, locale),
								fontCabecera));
						cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
						cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
						table.addCell(cell1);
						for (int a = 0; a < 54; a++) {
							if ((laFila.getArraySemana()[a].length() > 0)) {
								cell1 = new PdfPCell(new Paragraph(
										valorEnHoras(arrayTotalPlanta[a]),
										fontDatosHoras));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);

							} else {
								cell1 = new PdfPCell(new Paragraph("",
										fontDatos));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);
							}
						}
						// como es una nueva planta añadimos la tabla al
						// documento.
						// Creamos la cabecera de la nueva tabla
						tableTitulosCabecera = EncabezadoTablaPorEdificios(
								fontCabecera, gama, edificio, zona, planta);
						doc.add(tableTitulosCabecera);
						// Las dos primeras lineas son la cabecera que se tiene
						// que repetir en todas las hojas que ocupe
						// la tabla
						table.setHeaderRows(2);
						table.setSpacingAfter(10f);
						doc.add(table);
					}

					// Creamos una nueva tabla para la planta
					tableCabecera = cabeceraSemanasPorEdificios(fontCabecera,
							filterPrevAnual.getAnio());
					table = new PdfPTable(tableCabecera);
					table.setWidths(columnWidths);
					table.setWidthPercentage(100);
					table.setHorizontalAlignment(Element.ALIGN_LEFT);

					// Inicializar valores de totales por zona
					arrayTotalPlanta = new Integer[54];
				}

				// Si es una nueva Zona pero dentro del mismo Edificio y gama
				if (!zona.equals(laFila.getZona().toString())
						&& edificio.equals(laFila.getEdificio().toString())
						&& gama.equals(laFila.getGama().toString())) {
					// Si no es el primero metemos los totales de la zona
					// anterior
					if (!esPrimero) {
						// Añadimos la linea de totales por planta
						cell1 = new PdfPCell(new Paragraph("", fontCabecera));
						table.addCell(cell1);
						cell1 = new PdfPCell(new Paragraph(
								this.appMessageSource.getMessage(
										"prevAnual.totalPlanta", null, locale),
								fontCabecera));
						cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
						cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
						table.addCell(cell1);
						for (int a = 0; a < 54; a++) {
							if ((laFila.getArraySemana()[a].length() > 0)) {
								cell1 = new PdfPCell(new Paragraph(
										valorEnHoras(arrayTotalPlanta[a]),
										fontDatosHoras));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);

							} else {
								cell1 = new PdfPCell(new Paragraph("",
										fontDatos));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);
							}
						}

						// Añadimos la linea de totales por zona
						cell1 = new PdfPCell(new Paragraph("", fontCabecera));
						table.addCell(cell1);
						cell1 = new PdfPCell(new Paragraph(
								this.appMessageSource.getMessage(
										"prevAnual.totalZona", null, locale),
								fontCabecera));
						cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
						cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
						table.addCell(cell1);
						for (int a = 0; a < 54; a++) {
							if ((laFila.getArraySemana()[a].length() > 0)) {
								cell1 = new PdfPCell(new Paragraph(
										valorEnHoras(arrayTotalZona[a]),
										fontDatosHoras));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);

							} else {
								cell1 = new PdfPCell(new Paragraph("",
										fontDatos));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);
							}
						}
						// como es una nueva zona añadimos la tabla al
						// documento.
						// Creamos la cabecera de la nueva tabla
						tableTitulosCabecera = EncabezadoTablaPorEdificios(
								fontCabecera, gama, edificio, zona, planta);
						doc.add(tableTitulosCabecera);
						// Las dos primeras lineas son la cabecera que se tiene
						// que repetir en todas las hojas que ocupe
						// la tabla
						table.setHeaderRows(2);
						table.setSpacingAfter(10f);
						doc.add(table);
					}

					// Creamos una nueva tabla para la zona
					tableCabecera = cabeceraSemanasPorEdificios(fontCabecera,
							filterPrevAnual.getAnio());
					table = new PdfPTable(tableCabecera);
					table.setWidths(columnWidths);
					table.setWidthPercentage(100);
					table.setHorizontalAlignment(Element.ALIGN_LEFT);

					// Inicializar valores de totales por zona
					arrayTotalZona = new Integer[54];
					arrayTotalPlanta = new Integer[54];
				}
				// Si es un nuevo edificio dentro de la misma Gama
				if (!edificio.equals(laFila.getEdificio().toString())
						&& gama.equals(laFila.getGama().toString())) {
					// Si no es el primero metemos los totales del edificio
					// anterior
					if (!esPrimero) {
						// Añadimos la linea de totales por planta
						cell1 = new PdfPCell(new Paragraph("", fontCabecera));
						table.addCell(cell1);
						cell1 = new PdfPCell(new Paragraph(
								this.appMessageSource.getMessage(
										"prevAnual.totalPlanta", null, locale),
								fontCabecera));
						cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
						cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
						table.addCell(cell1);
						for (int a = 0; a < 54; a++) {
							if ((laFila.getArraySemana()[a].length() > 0)) {
								cell1 = new PdfPCell(new Paragraph(
										valorEnHoras(arrayTotalPlanta[a]),
										fontDatosHoras));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);

							} else {
								cell1 = new PdfPCell(new Paragraph("",
										fontDatos));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);
							}
						}

						// Añadimos la linea de totales por zona
						cell1 = new PdfPCell(new Paragraph("", fontCabecera));
						table.addCell(cell1);
						cell1 = new PdfPCell(new Paragraph(
								this.appMessageSource.getMessage(
										"prevAnual.totalZona", null, locale),
								fontCabecera));
						cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
						cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
						table.addCell(cell1);
						for (int a = 0; a < 54; a++) {
							if ((laFila.getArraySemana()[a].length() > 0)) {
								cell1 = new PdfPCell(new Paragraph(
										valorEnHoras(arrayTotalZona[a]),
										fontDatosHoras));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);

							} else {
								cell1 = new PdfPCell(new Paragraph("",
										fontDatos));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);
							}
						}

						// Añadimos la linea de totales por edificio
						cell1 = new PdfPCell(new Paragraph("", fontCabecera));
						table.addCell(cell1);
						cell1 = new PdfPCell(
								new Paragraph(
										this.appMessageSource.getMessage(
												"prevAnual.totalEdificio",
												null, locale), fontCabecera));
						cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
						cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
						table.addCell(cell1);
						for (int a = 0; a < 54; a++) {
							if ((laFila.getArraySemana()[a].length() > 0)) {
								cell1 = new PdfPCell(new Paragraph(
										valorEnHoras(arrayTotalEdificio[a]),
										fontDatosHoras));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);

							} else {
								cell1 = new PdfPCell(new Paragraph("",
										fontDatos));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);
							}
						}
						// como es un nuevo edificios añadimos la tabla al
						// documento.
						// Creamos la cabecera de la nueva tabla
						tableTitulosCabecera = EncabezadoTablaPorEdificios(
								fontCabecera, gama, edificio, zona, planta);
						doc.add(tableTitulosCabecera);
						// Las dos primeras lineas son la cabecera que se tiene
						// que repetir en todas las hojas que ocupe
						// la tabla
						table.setHeaderRows(2);
						table.setSpacingAfter(10f);
						doc.add(table);
					}

					// Creamos una nueva tabla para el edificio
					tableCabecera = cabeceraSemanasPorEdificios(fontCabecera,
							filterPrevAnual.getAnio());
					table = new PdfPTable(tableCabecera);
					table.setWidths(columnWidths);
					table.setWidthPercentage(100);
					table.setHorizontalAlignment(Element.ALIGN_LEFT);

					// Inicializar valores de totales por Edificio y zona
					arrayTotalEdificio = new Integer[54];
					arrayTotalZona = new Integer[54];
					arrayTotalPlanta = new Integer[54];
				}

				// Si es una nueva Gama
				if (!gama.equals(laFila.getGama().toString())) {
					// Si no es el primero metemos los totales de la gama
					// anterior
					if (!esPrimero) {
						// Añadimos la linea de totales por planta
						cell1 = new PdfPCell(new Paragraph("", fontCabecera));
						table.addCell(cell1);
						cell1 = new PdfPCell(new Paragraph(
								this.appMessageSource.getMessage(
										"prevAnual.totalPlanta", null, locale),
								fontCabecera));
						cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
						cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
						table.addCell(cell1);
						for (int a = 0; a < 54; a++) {
							if ((laFila.getArraySemana()[a].length() > 0)) {
								cell1 = new PdfPCell(new Paragraph(
										valorEnHoras(arrayTotalPlanta[a]),
										fontDatosHoras));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);

							} else {
								cell1 = new PdfPCell(new Paragraph("",
										fontDatos));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);
							}
						}

						// Añadimos la linea de totales por zona
						cell1 = new PdfPCell(new Paragraph("", fontCabecera));
						table.addCell(cell1);
						cell1 = new PdfPCell(new Paragraph(
								this.appMessageSource.getMessage(
										"prevAnual.totalZona", null, locale),
								fontCabecera));
						cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
						cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
						table.addCell(cell1);
						for (int a = 0; a < 54; a++) {
							if ((laFila.getArraySemana()[a].length() > 0)) {
								cell1 = new PdfPCell(new Paragraph(
										valorEnHoras(arrayTotalZona[a]),
										fontDatosHoras));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);

							} else {
								cell1 = new PdfPCell(new Paragraph("",
										fontDatos));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);
							}
						}

						// Añadimos la linea de totales por Edificio
						cell1 = new PdfPCell(new Paragraph("", fontCabecera));
						table.addCell(cell1);
						cell1 = new PdfPCell(
								new Paragraph(
										this.appMessageSource.getMessage(
												"prevAnual.totalEdificio",
												null, locale), fontCabecera));
						cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
						cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
						table.addCell(cell1);
						for (int a = 0; a < 54; a++) {
							if ((laFila.getArraySemana()[a].length() > 0)) {
								cell1 = new PdfPCell(new Paragraph(
										valorEnHoras(arrayTotalEdificio[a]),
										fontDatosHoras));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);

							} else {
								cell1 = new PdfPCell(new Paragraph("",
										fontDatos));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);
							}
						}

						// Añadimos la linea de totales por gama
						cell1 = new PdfPCell(new Paragraph("", fontCabecera));
						table.addCell(cell1);
						cell1 = new PdfPCell(new Paragraph(
								this.appMessageSource.getMessage(
										"prevAnual.totalGama", null, locale),
								fontCabecera));
						cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
						cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
						table.addCell(cell1);
						for (int a = 0; a < 54; a++) {
							if ((laFila.getArraySemana()[a].length() > 0)) {
								cell1 = new PdfPCell(new Paragraph(
										valorEnHoras(arrayTotalGama[a]),
										fontDatosHoras));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);

							} else {
								cell1 = new PdfPCell(new Paragraph("",
										fontDatos));
								cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
								table.addCell(cell1);
							}
						}

						// como es una nueva gama añadimos la tabla al
						// documento.
						// Creamos la cabecera de la nueva tabla
						tableTitulosCabecera = EncabezadoTablaPorEdificios(
								fontCabecera, gama, edificio, zona, planta);
						doc.add(tableTitulosCabecera);
						// Las dos primeras lineas son la cabecera que se tiene
						// que repetir en todas las hojas que ocupe
						// la tabla
						table.setHeaderRows(2);
						table.setSpacingAfter(10f);
						doc.add(table);
					}

					// Creamos una nueva tabla para la gama
					tableCabecera = cabeceraSemanasPorEdificios(fontCabecera,
							filterPrevAnual.getAnio());
					table = new PdfPTable(tableCabecera);
					table.setWidths(columnWidths);
					table.setWidthPercentage(100);
					table.setHorizontalAlignment(Element.ALIGN_LEFT);

					// Inicializar valores de totales de gama y Edificio
					arrayTotalGama = new Integer[54];
					arrayTotalEdificio = new Integer[54];
					arrayTotalZona = new Integer[54];
					arrayTotalPlanta = new Integer[54];
				}

				// Añadimos los datos de la máquina
				table.setHorizontalAlignment(Element.ALIGN_LEFT);
				cell1 = new PdfPCell(new Paragraph(
						laFila.getCodigoMaq() == null ? ""
								: laFila.getCodigoMaq(), fontCabecera));
				table.addCell(cell1);
				cell1 = new PdfPCell(new Paragraph(
						laFila.getDescripcion() == null ? ""
								: laFila.getDescripcion(), fontCabecera));
				table.addCell(cell1);
				for (int a = 0; a < 54; a++) {
					if ((laFila.getArraySemana()[a].length() > 0)) {
						cell1 = new PdfPCell(new Paragraph(
								laFila.getArraySemana()[a].length() == 0 ? ""
										: valorEnHoras(Integer.parseInt(laFila
												.getArraySemana()[a])),
								fontDatosHoras));
						table.addCell(cell1);

						// Se guardan en el array la suma de tiempos por semana
						// y gama
						String nTiempo = laFila.getArraySemana()[a].length() == 0 ? "0"
								: laFila.getArraySemana()[a].toString();
						arrayTotalGama[a] = arrayTotalGama[a] == null ? Integer
								.parseInt(nTiempo) : arrayTotalGama[a]
								+ Integer.parseInt(nTiempo);
						arrayTotalEdificio[a] = arrayTotalEdificio[a] == null ? Integer
								.parseInt(nTiempo) : arrayTotalEdificio[a]
								+ Integer.parseInt(nTiempo);
						arrayTotalZona[a] = arrayTotalZona[a] == null ? Integer
								.parseInt(nTiempo) : arrayTotalZona[a]
								+ Integer.parseInt(nTiempo);
						arrayTotalPlanta[a] = arrayTotalPlanta[a] == null ? Integer
								.parseInt(nTiempo) : arrayTotalPlanta[a]
								+ Integer.parseInt(nTiempo);

					} else {
						cell1 = new PdfPCell(new Paragraph("", fontDatos));
						table.addCell(cell1);
					}

				}

				gama = laFila.getGama().toString();
				edificio = laFila.getEdificio().toString();
				zona = laFila.getZona().toString();
				planta = laFila.getPlanta().toString();
				esPrimero = false;
			}

			// ************************************************
			// *******************Para el último registro*****
			// ************************************************
			// Creamos la cabecera de la nueva tabla
			tableTitulosCabecera = EncabezadoTablaPorEdificios(fontCabecera,
					gama, edificio, zona, planta);
			doc.add(tableTitulosCabecera);

			table.setSpacingAfter(10f);
			table.setSpacingBefore(0);

			// Añadimos la linea de totales por planta
			cell1 = new PdfPCell(new Paragraph("", fontCabecera));
			table.addCell(cell1);
			cell1 = new PdfPCell(new Paragraph(
					this.appMessageSource.getMessage("prevAnual.totalPlanta",
							null, locale), fontCabecera));
			cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
			cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
			table.addCell(cell1);
			for (int a = 0; a < 54; a++) {
				if ((arrayTotalPlanta[a] > 0)) {
					cell1 = new PdfPCell(new Paragraph(
							valorEnHoras(arrayTotalPlanta[a]), fontDatosHoras));
					cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
					table.addCell(cell1);

				} else {
					cell1 = new PdfPCell(new Paragraph("", fontDatos));
					cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
					table.addCell(cell1);
				}
			}

			// Añadimos la linea de totales por zona
			cell1 = new PdfPCell(new Paragraph("", fontCabecera));
			table.addCell(cell1);
			cell1 = new PdfPCell(new Paragraph(
					this.appMessageSource.getMessage("prevAnual.totalZona",
							null, locale), fontCabecera));
			cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
			cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
			table.addCell(cell1);
			for (int a = 0; a < 54; a++) {
				if ((arrayTotalPlanta[a] > 0)) {
					cell1 = new PdfPCell(new Paragraph(
							valorEnHoras(arrayTotalZona[a]), fontDatosHoras));
					cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
					table.addCell(cell1);

				} else {
					cell1 = new PdfPCell(new Paragraph("", fontDatos));
					cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
					table.addCell(cell1);
				}
			}

			// Añadimos la linea de totales por Edificio
			cell1 = new PdfPCell(new Paragraph("", fontCabecera));
			table.addCell(cell1);
			cell1 = new PdfPCell(new Paragraph(
					this.appMessageSource.getMessage("prevAnual.totalEdificio",
							null, locale), fontCabecera));
			cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
			cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
			table.addCell(cell1);
			for (int a = 0; a < 54; a++) {
				if ((arrayTotalPlanta[a] > 0)) {
					cell1 = new PdfPCell(
							new Paragraph(valorEnHoras(arrayTotalEdificio[a]),
									fontDatosHoras));
					cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
					table.addCell(cell1);

				} else {
					cell1 = new PdfPCell(new Paragraph("", fontDatos));
					cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
					table.addCell(cell1);
				}
			}

			// Añadimos la linea de totales por gama
			cell1 = new PdfPCell(new Paragraph("", fontCabecera));
			table.addCell(cell1);
			cell1 = new PdfPCell(new Paragraph(
					this.appMessageSource.getMessage("prevAnual.totalGama",
							null, locale), fontCabecera));
			cell1.setHorizontalAlignment(Element.ALIGN_RIGHT);
			cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
			table.addCell(cell1);
			for (int a = 0; a < 54; a++) {
				if ((arrayTotalGama[a] > 0)) {
					cell1 = new PdfPCell(new Paragraph(
							valorEnHoras(arrayTotalGama[a]), fontDatosHoras));
					cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
					table.addCell(cell1);

				} else {
					cell1 = new PdfPCell(new Paragraph("", fontDatos));
					cell1.setBackgroundColor(BaseColor.LIGHT_GRAY);
					table.addCell(cell1);
				}
			}

			doc.add(table);

		} catch (DocumentException dex) {
			dex.printStackTrace();
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			if (doc != null) {
				doc.close();
			}
			if (docWriter != null) {
				docWriter.close();
			}
		}
	}

	/**
	 * Escribe los filtros seleccionados
	 * 
	 * @param Font
	 * @param String
	 * @param String
	 * @param String
	 * @param String
	 * @return
	 */
	public PdfPTable filtrosPorEdificios(PrevAnual filterPrevAnual) {
		Font fontDatos = new Font(FontFamily.HELVETICA, 7, Font.BOLD,
				BaseColor.BLACK);

		String idioma = locale.getLanguage();

		PdfPTable table = new PdfPTable(3);
		table.setSpacingAfter(5);
		table.setSpacingBefore(10);
		table.setWidthPercentage(100);
		float[] columnWidths = new float[] { 5f, 5f, 5f };
		try {
			table.setWidths(columnWidths);
		} catch (DocumentException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		table.setHorizontalAlignment(Element.ALIGN_LEFT);

		PdfPCell cell1;
		cell1 = new PdfPCell(new Paragraph(filterPrevAnual.getTerritorio()
				.equals("") ? this.appMessageSource.getMessage(
				"prevAnual.territorio", null, locale) + ": "
				: this.appMessageSource.getMessage("prevAnual.territorio",
						null, locale) + ": " + filterPrevAnual.getTerritorio(),
				fontDatos));
		cell1.setBorder(PdfPCell.NO_BORDER);
		table.addCell(cell1);

		cell1 = new PdfPCell(
				new Paragraph(
						filterPrevAnual.getZona().equals("") ? this.appMessageSource
								.getMessage("prevAnual.zona", null, locale)
								+ ": " : this.appMessageSource.getMessage(
								"prevAnual.zona", null, locale)
								+ ": "
								+ filterPrevAnual.getZona(), fontDatos));
		cell1.setBorder(PdfPCell.NO_BORDER);
		table.addCell(cell1);

		cell1 = new PdfPCell(new Paragraph(filterPrevAnual.getPlanta().equals(
				"") ? this.appMessageSource.getMessage("prevAnual.planta",
				null, locale) + ": " : this.appMessageSource.getMessage(
				"prevAnual.planta", null, locale)
				+ ": "
				+ filterPrevAnual.getPlanta(), fontDatos));
		cell1.setBorder(PdfPCell.NO_BORDER);
		table.addCell(cell1);

		cell1 = new PdfPCell(new Paragraph(filterPrevAnual.getSituacion()
				.equals("") ? this.appMessageSource.getMessage(
				"prevAnual.situacion", null, locale) + ": "
				: this.appMessageSource.getMessage("prevAnual.situacion", null,
						locale) + ": " + filterPrevAnual.getSituacion(),
				fontDatos));
		cell1.setBorder(PdfPCell.NO_BORDER);
		table.addCell(cell1);

		cell1 = new PdfPCell(
				new Paragraph(
						filterPrevAnual.getGama().equals("") ? this.appMessageSource
								.getMessage("prevAnual.gama", null, locale)
								+ ": " : this.appMessageSource.getMessage(
								"prevAnual.gama", null, locale)
								+ ": "
								+ filterPrevAnual.getGama(), fontDatos));
		cell1.setBorder(PdfPCell.NO_BORDER);
		table.addCell(cell1);

		cell1 = new PdfPCell(new Paragraph("", fontDatos));
		cell1.setBorder(PdfPCell.NO_BORDER);
		table.addCell(cell1);

		if (filterPrevAnual.getMaquina() != null) {
			cell1 = new PdfPCell(
					new Paragraph(
							filterPrevAnual.getMaquina().equals("") ? this.appMessageSource
									.getMessage("prevAnual.equipo", null,
											locale)
									+ ": " : this.appMessageSource.getMessage(
									"prevAnual.equipo", null, locale)
									+ ": "
									+ filterPrevAnual.getMaquina(), fontDatos));
		} else {
			cell1 = new PdfPCell(new Paragraph(
					this.appMessageSource.getMessage("prevAnual.equipo", null,
							locale) + ": ", fontDatos));
		}
		cell1.setBorder(PdfPCell.NO_BORDER);
		table.addCell(cell1);

		cell1 = new PdfPCell(new Paragraph(filterPrevAnual.getParaContrata()
				.equals("") ? this.appMessageSource.getMessage(
				"prevAnual.paraContrata", null, locale) + ": "
				: this.appMessageSource.getMessage("prevAnual.paraContrata",
						null, locale)
						+ ": "
						+ filterPrevAnual.getParaContrata(), fontDatos));
		cell1.setBorder(PdfPCell.NO_BORDER);
		table.addCell(cell1);

		String filtroBaja = this.appMessageSource.getMessage(
				"prevAnual.equipBaja", null, locale) + ": ";
		if (filterPrevAnual.getIncluirBaja() != null
				&& filterPrevAnual.getIncluirBaja() == 1) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				filtroBaja = this.appMessageSource.getMessage(
						"prevAnual.equipBaja", null, locale) + ": BAI";
			} else {
				filtroBaja = this.appMessageSource.getMessage(
						"prevAnual.equipBaja", null, locale) + ": SÍ";
			}
		} else {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				filtroBaja = this.appMessageSource.getMessage(
						"prevAnual.equipBaja", null, locale) + ": EZ";
			} else {
				filtroBaja = this.appMessageSource.getMessage(
						"prevAnual.equipBaja", null, locale) + ": NO";
			}
		}
		cell1 = new PdfPCell(new Paragraph(filtroBaja, fontDatos));
		cell1.setBorder(PdfPCell.NO_BORDER);
		table.addCell(cell1);

		return table;

	}

}
