package com.ejie.aa20b.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Aa20bParametros {

	private static final Logger logger = Logger
			.getLogger(Aa20bParametros.class);

	public Properties getParametros() throws IOException {
		Properties par = null;

		par = new Properties();
		InputStream in = getClass().getResourceAsStream(
				"/aa20b/aa20b.properties");
		par.load(in);
		in.close();

		return (par);
	}

	public Properties getParametros(String path) throws IOException {
		Properties par = null;

		par = new Properties();
		InputStream in = getClass().getResourceAsStream(path);
		par.load(in);
		in.close();
		return (par);
	}

	/**
	 * Obtiene la característica astrClave de la configuración.
	 * 
	 * @param astrClave
	 *            característica que queremos obtener.
	 * @return String valor que tiene la característica buscada.
	 */
	public static String get(String astrClave) {
		String lstrValor = "";

		Aa20bParametros utiles = new Aa20bParametros();
		Properties p1;
		try {
			p1 = utiles.getParametros("/aa20b/aa20b.properties");
			lstrValor = p1.getProperty(astrClave);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			logger.error("get - IOException  " + e.getMessage());
			e.printStackTrace();
		}
		if (astrClave.equals("url.base")) {
			logger.error("lstrValor" + lstrValor);
			lstrValor = lstrValor.replace(".net", ".eus");
			logger.error("lstrValoreus" + lstrValor);
			lstrValor = lstrValor.replace(".NET", ".EUS");
			logger.error("strValorEUS" + lstrValor);
		}

		return lstrValor;
	}

}
