package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.ZonasDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Zonas;

/**
 * ZonasServiceImpl generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

@Service(value = "zonasService")
public class ZonasServiceImpl implements ZonasService {

	@Autowired
	private ZonasDao zonasDao;

	/**
	 * Inserts a single row in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return Zonas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Zonas add(Zonas zonas) {
		return this.zonasDao.add(zonas);
	}

	/**
	 * Updates a single row in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return Zonas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Zonas update(Zonas zonas) {
		return this.zonasDao.update(zonas);
	}

	/**
	 * Finds a single row in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return Zonas
	 */
	public Zonas find(Zonas zonas) {
		return (Zonas) this.zonasDao.find(zonas);
	}

	/**
	 * Finds a single row in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return Zonas
	 */
	public Zonas obtenerZona(Zonas zonas) {
		return (Zonas) this.zonasDao.obtenerZona(zonas);
	}

	/**
	 * Finds a List of rows in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Zonas> findAll(Zonas zonas, Pagination pagination) {
		return (List<Zonas>) this.zonasDao.findAll(zonas, pagination);
	}

	/**
	 * Counts rows in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return Long
	 */
	public Long findAllCount(Zonas zonas) {
		return this.zonasDao.findAllCount(zonas);
	}

	/**
	 * Finds rows in the Zonas table using like.
	 * 
	 * @param zonas
	 *            Zonas
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Zonas> findAllLike(Zonas zonas, Pagination pagination,
			Boolean startsWith) {
		return (List<Zonas>) this.zonasDao.findAllLike(zonas, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Zonas table using like.
	 * 
	 * @param zonas
	 *            Zonas
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Zonas zonas, Boolean startsWith) {
		return this.zonasDao.findAllLikeCount(zonas, startsWith);
	}

	/**
	 * Deletes a single row in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Zonas zonas) {
		this.zonasDao.remove(zonas);
	}

	/**
	 * Deletes multiple rows in the Zonas table.
	 * 
	 * @param zonasList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Zonas> zonasList) {
		for (Zonas zonasAux : zonasList) {
			this.zonasDao.remove(zonasAux);
		}
	}

	public List<Zonas> obtenerZonasEdificioLibres(String codEdificio,
			String language) {
		return this.zonasDao.obtenerZonasEdificioLibres(codEdificio, language);
	}

	public List<Zonas> obtenerZonasEdificioOcupadas(String codEdificio,
			String language) {
		return this.zonasDao
				.obtenerZonasEdificioOcupadas(codEdificio, language);
	}

	/**
	 * Obtener Zonas para el edificio especificado.
	 * 
	 * @param codEdif
	 *            String
	 * @return List
	 */
	public List<Zonas> obtenerZonasEdif(String codEdif) {
		return (List<Zonas>) this.zonasDao.obtenerZonasEdif(codEdif);
	}

	public List<Zonas> obtenerZonasEdifAlta(String codEdif) {
		return (List<Zonas>) this.zonasDao.obtenerZonasEdifAlta(codEdif);
	}

	/**
	 * Obtener Zonas para el edificio especificado.
	 * 
	 * @param codEdif
	 *            String
	 * @return List
	 */
	public List<Zonas> obtenerZonasEdifConPlanos(String codEdif) {
		return (List<Zonas>) this.zonasDao.obtenerZonasEdifConPlanos(codEdif);
	}

	/**
	 * Obtiene la lista de zonas de un edificio que no estan asignadas a un
	 * técnico
	 * 
	 * @param codEdificio
	 *            String
	 * @param idTecnico
	 *            Long
	 * @param language
	 *            String
	 * @return List
	 */

	public List<Zonas> buscaZonasEdificioTecnicoLibres(String codEdificio,
			Long idTecnico, String language) {
		return this.zonasDao.buscaZonasEdificioTecnicoLibres(codEdificio,
				idTecnico, language);
	}

	/**
	 * Obtiene la lista de zonas de un edificio que estan asignadas a un técnico
	 * 
	 * @param codEdificio
	 *            String
	 * @param idTecnico
	 *            Long
	 * @param language
	 *            String
	 * @return List
	 */
	public List<Zonas> buscaZonasEdificioTecnicoOcupadas(String codEdificio,
			Long idTecnico, String language) {
		return this.zonasDao.buscaZonasEdificioTecnicoOcupadas(codEdificio,
				idTecnico, language);
	}

	public Zonas obtenerZonaDesdeXlnets(Zonas zonas) {
		return this.zonasDao.obtenerZonaDesdeXlnets(zonas);
	}
}
