package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;

import java.util.List;

import com.ejie.aa20b.model.Zonas;

/**
 * ZonasService generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

public interface ZonasService {

	/**
	 * Inserts a single row in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return Zonas
	 */
	Zonas add(Zonas zonas);

	/**
	 * Updates a single row in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return Zonas
	 */
	Zonas update(Zonas zonas);

	/**
	 * Finds a single row in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return Zonas
	 */
	Zonas find(Zonas zonas);

	/**
	 * Finds a single row in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return Zonas
	 */
	Zonas obtenerZona(Zonas zonas);

	/**
	 * Finds a List of rows in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Zonas> findAll(Zonas zonas, Pagination pagination);

	/**
	 * Counts rows in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return Long
	 */
	Long findAllCount(Zonas zonas);

	/**
	 * Finds rows in the Zonas table using like.
	 * 
	 * @param zonas
	 *            Zonas
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Zonas> findAllLike(Zonas zonas, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Zonas table using like.
	 * 
	 * @param zonas
	 *            Zonas
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Zonas zonas, Boolean startsWith);

	/**
	 * Deletes a single row in the Zonas table.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return
	 */
	void remove(Zonas zonas);

	/**
	 * Deletes multiple rows in the Zonas table.
	 * 
	 * @param zonasList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Zonas> zonasList);

	List<Zonas> obtenerZonasEdificioLibres(String codEdificio, String language);

	List<Zonas> obtenerZonasEdificioOcupadas(String codEdificio, String language);

	/**
	 * Obtener Zonas para el edificio especificado.
	 * 
	 * @param codEdif
	 *            String
	 * @return List
	 */
	List<Zonas> obtenerZonasEdif(String codEdif);

	List<Zonas> obtenerZonasEdifAlta(String codEdif);

	/**
	 * Obtener Zonas para el edificio especificado.
	 * 
	 * @param codEdif
	 *            String
	 * @return List
	 */
	List<Zonas> obtenerZonasEdifConPlanos(String codEdif);

	/**
	 * Obtiene la lista de zonas de un edificio que no estan asignadas a un
	 * técnico
	 * 
	 * @param codEdificio
	 *            String
	 * @param idTecnico
	 *            Long
	 * @param language
	 *            String
	 * @return List
	 */

	List<Zonas> buscaZonasEdificioTecnicoLibres(String codEdificio,
			Long idTecnico, String language);

	/**
	 * Obtiene la lista de zonas de un edificio que estan asignadas a un técnico
	 * 
	 * @param codEdificio
	 *            String
	 * @param idTecnico
	 *            Long
	 * @param language
	 *            String
	 * @return List
	 */

	List<Zonas> buscaZonasEdificioTecnicoOcupadas(String codEdificio,
			Long idTecnico, String language);

	public Zonas obtenerZonaDesdeXlnets(Zonas zonas);
}
