package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.UsutecnicosDao;
import com.ejie.x38.dto.Pagination;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Usutecnicos;

/**
 * UsutecnicosServiceImpl generated by UDA, 11-mar-2015 9:14:58.
 * 
 * @author UDA
 */

@Service(value = "usutecnicosService")
public class UsutecnicosServiceImpl implements UsutecnicosService {

	@Autowired
	private UsutecnicosDao usutecnicosDao;

	/**
	 * Inserts a single row in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return Usutecnicos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Usutecnicos add(Usutecnicos usutecnicos) {
		return this.usutecnicosDao.add(usutecnicos);
	}

	/**
	 * Updates a single row in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return Usutecnicos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Usutecnicos update(Usutecnicos usutecnicos) {
		return this.usutecnicosDao.update(usutecnicos);
	}

	/**
	 * Finds a single row in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return Usutecnicos
	 */
	public Usutecnicos find(Usutecnicos usutecnicos) {
		return (Usutecnicos) this.usutecnicosDao.find(usutecnicos);
	}

	public Usutecnicos findTecnicoUsuario(Usutecnicos usutecnicos) {
		return (Usutecnicos) this.usutecnicosDao
				.findTecnicoUsuario(usutecnicos);
	}

	/**
	 * Finds a List of rows in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Usutecnicos> findAll(Usutecnicos usutecnicos,
			Pagination pagination) {
		return (List<Usutecnicos>) this.usutecnicosDao.findAll(usutecnicos,
				pagination);
	}

	/**
	 * Counts rows in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return Long
	 */
	public Long findAllCount(Usutecnicos usutecnicos) {
		return this.usutecnicosDao.findAllCount(usutecnicos);
	}

	/**
	 * Finds rows in the Usutecnicos table using like.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Usutecnicos> findAllLike(Usutecnicos usutecnicos,
			Pagination pagination, Boolean startsWith) {
		return (List<Usutecnicos>) this.usutecnicosDao.findAllLike(usutecnicos,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Usutecnicos table using like.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Usutecnicos usutecnicos, Boolean startsWith) {
		return this.usutecnicosDao.findAllLikeCount(usutecnicos, startsWith);
	}

	/**
	 * Deletes a single row in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Usutecnicos usutecnicos) {
		this.usutecnicosDao.remove(usutecnicos);
	}

	/**
	 * Deletes multiple rows in the Usutecnicos table.
	 * 
	 * @param usutecnicosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Usutecnicos> usutecnicosList) {
		for (Usutecnicos usutecnicosAux : usutecnicosList) {
			this.usutecnicosDao.remove(usutecnicosAux);
		}
	}

	/**
	 * Finds a List of rows in the Usutecnicos table.
	 * 
	 * @param idUsuario
	 *            String
	 * @return List
	 */
	public List<Usutecnicos> obtenerTecnicosUsuarioAsignados(String idUsuario) {
		return (List<Usutecnicos>) this.usutecnicosDao
				.obtenerTecnicosUsuarioAsignados(idUsuario);
	}

	/**
	 * Finds a List of rows in the Usutecnicos table.
	 * 
	 * @param idUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return List
	 */
	public List<Usutecnicos> obtenerTecnicosUsuarioLibres(String idUsuario,
			Integer idServicio) {
		return (List<Usutecnicos>) this.usutecnicosDao
				.obtenerTecnicosUsuarioLibres(idUsuario, idServicio);
	}

	/**
	 * Obtiene tecnicos asociados al usuario que pertenecen al edificio que se
	 * va a desasociar Y que no están en los edificios que todavía mantiene
	 * asociados.
	 * 
	 * @param idUsuario
	 *            String
	 * @param edificiosSeleccionados
	 *            ArrayList<String>
	 * @param edificiosNOSeleccionados
	 *            ArrayList<String>
	 * @return List
	 */
	public List<Usutecnicos> comprobarTecnicosEdificio(String idUsuario,
			ArrayList<String> edificiosSeleccionados,
			ArrayList<String> edificiosNOSeleccionados) {

		// Obtener los tecnicos asociados a los edificios seleccionados Y que no
		// están asociados a lo otros edificios que tiene asociado el Usuario
		List<Usutecnicos> tecnicosEdificios = this.usutecnicosDao
				.comprobarTecnicosEdificio(idUsuario, edificiosSeleccionados,
						edificiosNOSeleccionados);

		return tecnicosEdificios;
	}

	/**
	 * Elimina todos los tecnicos asociados a un usuario in the Usutecnicos
	 * table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return
	 */
	public Usutecnicos restaTodosTecnicosUsu(Usutecnicos usutecnicos) {
		return this.usutecnicosDao.restaTodosTecnicosUsu(usutecnicos);
	}

	/**
	 * Obtener tecnicos de asociados a un edificio/Zona y al mismo servicio que
	 * el código de Parte
	 * 
	 * @param idCodigo
	 *            Integer
	 * @param idEdificio
	 *            String
	 * @param idZona
	 *            Integer
	 * @return List
	 */
	public List<Usutecnicos> obtenerTecnicosUsuServEdificio(Integer idCodigo,
			String idEdificio, Integer idZona, boolean soloMovilGmao) {
		return (List<Usutecnicos>) this.usutecnicosDao
				.obtenerTecnicosUsuServEdificio(idCodigo, idEdificio, idZona,
						soloMovilGmao);
	}

}
