package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;

import java.util.ArrayList;
import java.util.List;

import com.ejie.aa20b.model.Usutecnicos;

/**
 * UsutecnicosService generated by UDA, 11-mar-2015 9:14:58.
 * 
 * @author UDA
 */

public interface UsutecnicosService {

	/**
	 * Inserts a single row in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return Usutecnicos
	 */
	Usutecnicos add(Usutecnicos usutecnicos);

	/**
	 * Updates a single row in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return Usutecnicos
	 */
	Usutecnicos update(Usutecnicos usutecnicos);

	/**
	 * Finds a single row in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return Usutecnicos
	 */
	Usutecnicos find(Usutecnicos usutecnicos);

	Usutecnicos findTecnicoUsuario(Usutecnicos usutecnicos);

	/**
	 * Finds a List of rows in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Usutecnicos> findAll(Usutecnicos usutecnicos, Pagination pagination);

	/**
	 * Counts rows in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return Long
	 */
	Long findAllCount(Usutecnicos usutecnicos);

	/**
	 * Finds rows in the Usutecnicos table using like.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Usutecnicos> findAllLike(Usutecnicos usutecnicos,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Usutecnicos table using like.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Usutecnicos usutecnicos, Boolean startsWith);

	/**
	 * Deletes a single row in the Usutecnicos table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return
	 */
	void remove(Usutecnicos usutecnicos);

	/**
	 * Deletes multiple rows in the Usutecnicos table.
	 * 
	 * @param usutecnicosList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Usutecnicos> usutecnicosList);

	/**
	 * Finds a List of rows in the Usutecnicos table.
	 * 
	 * @param idUsuario
	 *            String
	 * @return List
	 */
	List<Usutecnicos> obtenerTecnicosUsuarioAsignados(String idUsuario);

	/**
	 * Finds a List of rows in the Usutecnicos table.
	 * 
	 * @param idUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return List
	 */
	List<Usutecnicos> obtenerTecnicosUsuarioLibres(String idUsuario,
			Integer idServicio);

	/**
	 * Obtiene tecnicos asociados al usuario que pertenecen al edificio que se
	 * va a desasociar Y que no están en los edificios que todavía mantiene
	 * asociados.
	 * 
	 * @param idUsuario
	 *            String
	 * @param edificiosSeleccionados
	 *            ArrayList<String>
	 * @return List
	 */
	List<Usutecnicos> comprobarTecnicosEdificio(String idUsuario,
			ArrayList<String> edificiosSeleccionados,
			ArrayList<String> edificiosNOSeleccionados);

	/**
	 * Elimina todos los tecnicos asociados a un usuario in the Usutecnicos
	 * table.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return Usutecnicos
	 */
	Usutecnicos restaTodosTecnicosUsu(Usutecnicos usutecnicos);

	/**
	 * Obtener tecnicos de usuario responsable de un servicio y asignado a un
	 * edificio
	 * 
	 * @param idCodigo
	 *            Integer
	 * @param idEdificio
	 *            String
	 * @param idZona
	 *            Integer
	 * @return List
	 */
	List<Usutecnicos> obtenerTecnicosUsuServEdificio(Integer idCodigo,
			String idEdificio, Integer idZona, boolean soloMovilGmao);
}
