package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.UsuariosDao;
import com.ejie.aa20b.dao.UsutecnicosDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Usuarios;
import com.ejie.aa20b.model.Usutecnicos;

/**
 * UsuariosServiceImpl generated by UDA, 10-mar-2015 14:56:20.
 * 
 * @author UDA
 */

@Service(value = "usuariosService")
public class UsuariosServiceImpl implements UsuariosService {

	@Autowired
	private UsuariosDao usuariosDao;

	@Autowired
	private UsutecnicosDao usutecnicosDao;

	/**
	 * Inserts a single row in the Usuarios table.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @return Usuarios
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Usuarios add(Usuarios usuarios) {
		return this.usuariosDao.add(usuarios);
	}

	/**
	 * Updates a single row in the Usuarios table.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @return Usuarios
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Usuarios update(Usuarios usuarios) {

		Usuarios usuaAct = this.usuariosDao.update(usuarios);

		// Si se ha marcado como no responsable se eliminan los tecnicos
		// asociados a dicho usuario
		if (usuaAct.getResponsable() == 0) {
			Usutecnicos usutecnicos = new Usutecnicos();
			usutecnicos.setUidPer(usuaAct.getUidPer());
			this.usutecnicosDao.eliminarTecnicosUsuario(usutecnicos);
		}

		return usuaAct;
	}

	/**
	 * Finds a single row in the Usuarios table.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @return Usuarios
	 */
	public Usuarios find(Usuarios usuarios) {
		return (Usuarios) this.usuariosDao.find(usuarios);
	}

	/**
	 * Finds a List of rows in the Usuarios table.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Usuarios> findAll(Usuarios usuarios, Pagination pagination) {
		return (List<Usuarios>) this.usuariosDao.findAll(usuarios, pagination);
	}

	/**
	 * Counts rows in the Usuarios table.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @return Long
	 */
	public Long findAllCount(Usuarios usuarios) {
		return this.usuariosDao.findAllCount(usuarios);
	}

	/**
	 * Finds rows in the Usuarios table using like.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Usuarios> findAllLike(Usuarios usuarios, Pagination pagination,
			Boolean startsWith) {
		return (List<Usuarios>) this.usuariosDao.findAllLike(usuarios,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Usuarios table using like.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Usuarios usuarios, Boolean startsWith) {
		return this.usuariosDao.findAllLikeCount(usuarios, startsWith);
	}

	/**
	 * Deletes a single row in the Usuarios table.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Usuarios usuarios) {
		this.usuariosDao.remove(usuarios);
	}

	/**
	 * Deletes multiple rows in the Usuarios table.
	 * 
	 * @param usuariosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Usuarios> usuariosList) {
		for (Usuarios usuariosAux : usuariosList) {
			this.usuariosDao.remove(usuariosAux);
		}
	}

}
