package com.ejie.aa20b.service;


import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Usuarios;

/**
 * UsuariosService generated by UDA, 10-mar-2015 14:56:20.
 * @author UDA
 */

public interface UsuariosService {

	/**
	 * Inserts a single row in the Usuarios table.
	 *
	 * @param usuarios Usuarios
	 * @return Usuarios
	 */
    Usuarios add(Usuarios usuarios);

	/**
	 * Updates a single row in the Usuarios table.
	 *
	 * @param usuarios Usuarios
	 * @return Usuarios
	 */
	Usuarios update(Usuarios usuarios);

	/**
	 * Finds a single row in the Usuarios table.
	 *
	 * @param usuarios Usuarios
	 * @return Usuarios
	 */
	Usuarios find(Usuarios usuarios);

	/**
	 * Finds a List of rows in the Usuarios table.
	 *
	 * @param usuarios Usuarios
	 * @param pagination Pagination
	 * @return List
	 */
	List<Usuarios> findAll(Usuarios usuarios, Pagination pagination);

	/**
	 * Counts rows in the Usuarios table.
	 *
	 * @param usuarios Usuarios
	 * @return Long
	 */
	Long findAllCount(Usuarios usuarios);
	
	/**
	 * Finds rows in the Usuarios table using like.
	 *
	 * @param usuarios Usuarios
	 * @param pagination Pagination
     * @param startsWith Boolean	 
	 * @return List
	 */
	List<Usuarios> findAllLike(Usuarios usuarios, Pagination pagination, Boolean startsWith) ;

	/**
	 * Counts rows in the Usuarios table using like.
	 *
	 * @param usuarios Usuarios
     * @param startsWith Boolean	 
	 * @return Long
	 */
	Long findAllLikeCount(Usuarios usuarios, Boolean startsWith) ;
  
	/**
	 * Deletes a single row in the Usuarios table.
	 *
	 * @param usuarios Usuarios
	 * @return 
	 */
	void remove(Usuarios usuarios);
	
	/**
	 * Deletes multiple rows in the Usuarios table.
	 *
	 * @param usuariosList List
	 * @return 
	 */	
	void removeMultiple(List<Usuarios> usuariosList);
    
}


