package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.UsuariosDao;
import com.ejie.aa20b.dao.UsuariosMovilDao;
import com.ejie.aa20b.dao.UsutecnicosDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.UsuariosMovil;

/**
 * UsuariosServiceImpl generated by UDA, 10-mar-2015 14:56:20.
 * 
 * @author UDA
 */

@Service(value = "usuariosMovilService")
public class UsuariosMovilServiceImpl implements UsuariosMovilService {

	@Autowired
	private UsuariosMovilDao usuariosMovilDao;

	/**
	 * Inserts a single row in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @return UsuariosMovil
	 */
	@Transactional(rollbackFor = Throwable.class)
	public UsuariosMovil add(UsuariosMovil usuariosMovil) {
		return this.usuariosMovilDao.add(usuariosMovil);
	}

	/**
	 * Updates a single row in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @return UsuariosMovil
	 */
	@Transactional(rollbackFor = Throwable.class)
	public UsuariosMovil update(UsuariosMovil usuariosMovil) {

		UsuariosMovil usuaAct = this.usuariosMovilDao.update(usuariosMovil);

		return usuaAct;
	}

	/**
	 * Finds a single row in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @return UsuariosMovil
	 */
	public UsuariosMovil find(UsuariosMovil usuariosMovil) {
		return (UsuariosMovil) this.usuariosMovilDao.find(usuariosMovil);
	}

	public UsuariosMovil findByLogin(UsuariosMovil usuariosMovil) {
		return (UsuariosMovil) this.usuariosMovilDao.findByLogin(usuariosMovil);
	}

	/**
	 * Finds a List of rows in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<UsuariosMovil> findAll(UsuariosMovil usuariosMovil,
			Pagination pagination) {
		return (List<UsuariosMovil>) this.usuariosMovilDao.findAll(
				usuariosMovil, pagination);
	}

	/**
	 * Counts rows in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @return Long
	 */
	public Long findAllCount(UsuariosMovil usuariosMovil) {
		return this.usuariosMovilDao.findAllCount(usuariosMovil);
	}

	/**
	 * Finds rows in the UsuariosMovil table using like.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<UsuariosMovil> findAllLike(UsuariosMovil usuariosMovil,
			Pagination pagination, Boolean startsWith) {
		return (List<UsuariosMovil>) this.usuariosMovilDao.findAllLike(
				usuariosMovil, pagination, startsWith);
	}

	/**
	 * Counts rows in the UsuariosMovil table using like.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(UsuariosMovil usuariosMovil, Boolean startsWith) {
		return this.usuariosMovilDao
				.findAllLikeCount(usuariosMovil, startsWith);
	}

	/**
	 * Deletes a single row in the UsuariosMovil table.
	 * 
	 * @param usuariosMovil
	 *            UsuariosMovil
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(UsuariosMovil usuariosMovil) {
		this.usuariosMovilDao.remove(usuariosMovil);
	}

	/**
	 * Deletes multiple rows in the UsuariosMovil table.
	 * 
	 * @param usuariosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<UsuariosMovil> usuariosMovilList) {
		for (UsuariosMovil usuariosMovilAux : usuariosMovilList) {
			this.usuariosMovilDao.remove(usuariosMovilAux);
		}
	}

}
