package com.ejie.aa20b.service;
import com.ejie.aa20b.dao.TipopresenciaDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Tipopresencia;

/**
 * TipopresenciaServiceImpl generated by UDA, 05-may-2015 13:24:41.
 * @author UDA
 */

@Service(value = "tipopresenciaService")
public class TipopresenciaServiceImpl implements TipopresenciaService {

	@Autowired
	private TipopresenciaDao tipopresenciaDao;

	/**
	 * Inserts a single row in the Tipopresencia table.
	 *
	 * @param tipopresencia Tipopresencia
	 * @return Tipopresencia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tipopresencia add(Tipopresencia tipopresencia) {
		return this.tipopresenciaDao.add(tipopresencia);
	}

	/**
	 * Updates a single row in the Tipopresencia table.
	 *
	 * @param tipopresencia Tipopresencia
	 * @return Tipopresencia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tipopresencia update(Tipopresencia tipopresencia) {
		return this.tipopresenciaDao.update(tipopresencia);
	 }

	/**
	 * Finds a single row in the Tipopresencia table.
	 *
	 * @param tipopresencia Tipopresencia
	 * @return Tipopresencia
	 */
	public Tipopresencia find(Tipopresencia tipopresencia) {
		return (Tipopresencia) this.tipopresenciaDao.find(tipopresencia);
	}

	/**
	 * Finds a List of rows in the Tipopresencia table.
	 *
	 * @param tipopresencia Tipopresencia
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Tipopresencia> findAll(Tipopresencia tipopresencia, Pagination pagination) {
		return (List<Tipopresencia>) this.tipopresenciaDao.findAll(tipopresencia, pagination);
	}
    
	/**
	 * Counts rows in the Tipopresencia table.
	 *
	 * @param tipopresencia Tipopresencia
	 * @return Long
	 */
	public Long findAllCount(Tipopresencia tipopresencia) {        
		return  this.tipopresenciaDao.findAllCount(tipopresencia);
	}

	/**
	 * Finds rows in the Tipopresencia table using like.
	 *
	 * @param tipopresencia Tipopresencia
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Tipopresencia> findAllLike(Tipopresencia tipopresencia, Pagination pagination, Boolean startsWith) {
		return (List<Tipopresencia>) this.tipopresenciaDao.findAllLike(tipopresencia, pagination, startsWith);
	}

	/**
	 * Counts rows in the Tipopresencia table using like.
	 *
	 * @param tipopresencia Tipopresencia
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tipopresencia tipopresencia, Boolean startsWith) {
		return this.tipopresenciaDao.findAllLikeCount(tipopresencia, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Tipopresencia table.
	 *
	 * @param tipopresencia Tipopresencia
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tipopresencia tipopresencia) {
		this.tipopresenciaDao.remove(tipopresencia);
	}
	
	/**
	 * Deletes multiple rows in the Tipopresencia table.
	 *
	 * @param tipopresenciaList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tipopresencia> tipopresenciaList) {
		for (Tipopresencia  tipopresenciaAux:tipopresenciaList) {
			this.tipopresenciaDao.remove(tipopresenciaAux);
		}
	}
	
}

