package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.TecnicosDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Tecnicos;

/**
 * TecnicosServiceImpl generated by UDA, 22-dic-2014 10:11:52.
 * 
 * @author UDA
 */

@Service(value = "tecnicosService")
public class TecnicosServiceImpl implements TecnicosService {

	@Autowired
	private TecnicosDao tecnicosDao;

	/**
	 * Inserts a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Tecnicos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tecnicos add(Tecnicos tecnicos) {
		return this.tecnicosDao.add(tecnicos);
	}

	/**
	 * Updates a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Tecnicos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tecnicos update(Tecnicos tecnicos) {
		return this.tecnicosDao.update(tecnicos);
	}

	/**
	 * Finds a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Tecnicos
	 */
	public Tecnicos find(Tecnicos tecnicos) {
		return (Tecnicos) this.tecnicosDao.find(tecnicos);
	}

	/**
	 * Finds a List of rows in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Tecnicos> findAll(Tecnicos tecnicos, Pagination pagination) {
		return (List<Tecnicos>) this.tecnicosDao.findAll(tecnicos, pagination);
	}

	/**
	 * Obtener tecnicos asociados a un edificio.
	 * 
	 * @param idedificio
	 *            String
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosAsociados(String idedificio) {
		return (List<Tecnicos>) this.tecnicosDao
				.obtenerTecnicosAsociados(idedificio);
	}

	/**
	 * Obtener tecnicos NO asociados a un edificio.
	 * 
	 * @param idedificio
	 *            String
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosNOAsociados(String idedificio) {
		return (List<Tecnicos>) this.tecnicosDao
				.obtenerTecnicosNOAsociados(idedificio);
	}

	/**
	 * Obtener tecnicos asociados a un edificio que NO están asociados a un
	 * parte.
	 * 
	 * @param idEdificio
	 *            String
	 * @param idParte
	 *            Integer
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosParteLibres(String idEdificio,
			String UIDUsuario, Integer idParte) {
		return (List<Tecnicos>) this.tecnicosDao.obtenerTecnicosParteLibres(
				idEdificio, UIDUsuario, idParte);
	}

	/**
	 * Counts rows in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Long
	 */
	public Long findAllCount(Tecnicos tecnicos) {
		return this.tecnicosDao.findAllCount(tecnicos);
	}

	/**
	 * Finds rows in the Tecnicos table using like.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Tecnicos> findAllLike(Tecnicos tecnicos, Pagination pagination,
			Boolean startsWith) {
		return (List<Tecnicos>) this.tecnicosDao.findAllLike(tecnicos,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Tecnicos table using like.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tecnicos tecnicos, Boolean startsWith) {
		return this.tecnicosDao.findAllLikeCount(tecnicos, startsWith);
	}

	/**
	 * Deletes a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tecnicos tecnicos) {
		this.tecnicosDao.remove(tecnicos);
	}

	/**
	 * Deletes multiple rows in the Tecnicos table.
	 * 
	 * @param tecnicosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tecnicos> tecnicosList) {
		for (Tecnicos tecnicosAux : tecnicosList) {
			this.tecnicosDao.remove(tecnicosAux);
		}
	}

	/**
	 * Obtener tecnicos asociados a un usuario que NO están en la tabla de
	 * tecnicosPlan
	 * 
	 * @param sUIDUsuario
	 *            String
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosUsuarioLibres(String sUIDUsuario) {
		return (List<Tecnicos>) this.tecnicosDao
				.obtenerTecnicosUsuarioLibres(sUIDUsuario);
	}

	/**
	 * Obtener tecnicos asociados a un usuario que SI están en la tabla de
	 * tecnicosPlan
	 * 
	 * @param sUIDUsuario
	 *            String
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosUsuarioAsignados(String sUIDUsuario) {
		return (List<Tecnicos>) this.tecnicosDao
				.obtenerTecnicosUsuarioAsignados(sUIDUsuario);
	}

	/**
	 * Obtener tecnicos de contrata NO asociados a una clase
	 * 
	 * @param idClase
	 *            Integer
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosClaseContrataLibres(Integer idClase) {
		return (List<Tecnicos>) this.tecnicosDao
				.obtenerTecnicosClaseContrataLibres(idClase);
	}

	/**
	 * Obtener tecnicos de contrata NO asociados a una clase y codigo
	 * 
	 * @param idClase
	 *            Integer
	 * @param idCodigo
	 *            Integer
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosClaseCodigoContrataLibres(
			Integer idClase, Integer idCodigo) {
		return (List<Tecnicos>) this.tecnicosDao
				.obtenerTecnicosClaseCodigoContrataLibres(idClase, idCodigo);
	}

	/**
	 * Obtener tecnicos de contrata asociados a una clase
	 * 
	 * @param idClase
	 *            Integer
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosClaseContrataAsignados(Integer idClase) {
		return (List<Tecnicos>) this.tecnicosDao
				.obtenerTecnicosClaseContrataAsignados(idClase);
	}

	/**
	 * Obtener tecnicos de contrata asociados a una clase y codigo
	 * 
	 * @param idClase
	 *            Integer
	 * @param idCodigo
	 *            Integer
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosClaseCodigoContrataAsignados(
			Integer idClase, Integer idCodigo) {
		return (List<Tecnicos>) this.tecnicosDao
				.obtenerTecnicosClaseCodigoContrataAsignados(idClase, idCodigo);
	}

	/**
	 * Updates a single row in the Tecnicos table.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Tecnicos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tecnicos modificarTecnico(Tecnicos tecnicos) {
		return this.tecnicosDao.modificarTecnico(tecnicos);
	}

	/**
	 * Obtener tecnicos de contrata para una clase, código y edificio Zona
	 * 
	 * @param idClase
	 *            Integer
	 * @param idServicio
	 *            Integer
	 * @param idCodigo
	 *            Integer
	 * @param idEdificio
	 *            String
	 * @param idZona
	 *            Integer
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosClaseContrataEdificio(Integer idClase,
			Integer idServicio, Integer idCodigo, String idEdificio,
			Integer idZona) {
		return (List<Tecnicos>) this.tecnicosDao
				.obtenerTecnicosClaseContrataEdificio(idClase, idServicio,
						idCodigo, idEdificio, idZona);
	}

	/**
	 * Obtener tecnicos Presencia
	 * 
	 * @param sUIDUsuario
	 *            String
	 * @param esResponsable
	 *            Boolean
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosPresencia(String sUIDUsuario,
			Boolean esResponsable) {
		return (List<Tecnicos>) this.tecnicosDao.obtenerTecnicosPresencia(
				sUIDUsuario, esResponsable);
	}

	/**
	 * Obtener tecnicos asociados a un edificio que NO están asociados a una
	 * ficha .
	 * 
	 * @param idEdificio
	 *            String
	 * @param idParte
	 *            Integer
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosFichaLibres(String idEdificio,
			String UIDUsuario, Integer idFicha) {
		return (List<Tecnicos>) this.tecnicosDao.obtenerTecnicosFichaLibres(
				idEdificio, UIDUsuario, idFicha);
	}

	/**
	 * Finds rows in the Tecnicos table using like.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @param sUIDUsuario
	 *            String
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Tecnicos> obtenerTecnicosDelUsuario(Tecnicos tecnicos,
			String sUIDUsuario, Boolean startsWith) {
		return (List<Tecnicos>) this.tecnicosDao.obtenerTecnicosDelUsuario(
				tecnicos, sUIDUsuario, startsWith);
	}

	/**
	 * Comprobar si ya existe otro técnico con el mismo UIDPuesto.
	 * 
	 * @param usuarioIntroducido
	 *            String
	 * @return Boolean
	 */
	public Boolean UIDPUESTOduplicado(String usuarioIntroducido, int idTecnico) {

		return this.tecnicosDao.UIDPUESTOduplicado(usuarioIntroducido,
				idTecnico);

	}

	@Override
	public Tecnicos actualizarUUIDtecnico(Tecnicos tecnico) {
		// TODO Auto-generated method stub
		return this.tecnicosDao.actualizarUUIDtecnico(tecnico);
	}
}
