package com.ejie.aa20b.service;
import com.ejie.aa20b.dao.TecnicoplanifDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Tecnicoplanif;

/**
 * TecnicoplanifServiceImpl generated by UDA, 01-abr-2015 12:44:36.
 * @author UDA
 */

@Service(value = "tecnicoplanifService")
public class TecnicoplanifServiceImpl implements TecnicoplanifService {

	@Autowired
	private TecnicoplanifDao tecnicoplanifDao;

	/**
	 * Inserts a single row in the Tecnicoplanif table.
	 *
	 * @param tecnicoplanif Tecnicoplanif
	 * @return Tecnicoplanif
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tecnicoplanif add(Tecnicoplanif tecnicoplanif) {
		return this.tecnicoplanifDao.add(tecnicoplanif);
	}

	/**
	 * Updates a single row in the Tecnicoplanif table.
	 *
	 * @param tecnicoplanif Tecnicoplanif
	 * @return Tecnicoplanif
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Tecnicoplanif update(Tecnicoplanif tecnicoplanif) {
		return this.tecnicoplanifDao.update(tecnicoplanif);
	 }

	/**
	 * Finds a single row in the Tecnicoplanif table.
	 *
	 * @param tecnicoplanif Tecnicoplanif
	 * @return Tecnicoplanif
	 */
	public Tecnicoplanif find(Tecnicoplanif tecnicoplanif) {
		return (Tecnicoplanif) this.tecnicoplanifDao.find(tecnicoplanif);
	}

	/**
	 * Finds a List of rows in the Tecnicoplanif table.
	 *
	 * @param tecnicoplanif Tecnicoplanif
	 * @param pagination Pagination
	 * @return List
	 */
	public List<Tecnicoplanif> findAll(Tecnicoplanif tecnicoplanif, Pagination pagination) {
		return (List<Tecnicoplanif>) this.tecnicoplanifDao.findAll(tecnicoplanif, pagination);
	}
    
	/**
	 * Counts rows in the Tecnicoplanif table.
	 *
	 * @param tecnicoplanif Tecnicoplanif
	 * @return Long
	 */
	public Long findAllCount(Tecnicoplanif tecnicoplanif) {        
		return  this.tecnicoplanifDao.findAllCount(tecnicoplanif);
	}

	/**
	 * Finds rows in the Tecnicoplanif table using like.
	 *
	 * @param tecnicoplanif Tecnicoplanif
	 * @param pagination Pagination
	 * @param startsWith Boolean
	 * @return List
	 */
	public List<Tecnicoplanif> findAllLike(Tecnicoplanif tecnicoplanif, Pagination pagination, Boolean startsWith) {
		return (List<Tecnicoplanif>) this.tecnicoplanifDao.findAllLike(tecnicoplanif, pagination, startsWith);
	}

	/**
	 * Counts rows in the Tecnicoplanif table using like.
	 *
	 * @param tecnicoplanif Tecnicoplanif
	 * @param startsWith Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Tecnicoplanif tecnicoplanif, Boolean startsWith) {
		return this.tecnicoplanifDao.findAllLikeCount(tecnicoplanif, startsWith);
	}
	    
	/**
	 * Deletes a single row in the Tecnicoplanif table.
	 *
	 * @param tecnicoplanif Tecnicoplanif
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Tecnicoplanif tecnicoplanif) {
		this.tecnicoplanifDao.remove(tecnicoplanif);
	}
	
	/**
	 * Deletes multiple rows in the Tecnicoplanif table.
	 *
	 * @param tecnicoplanifList List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Tecnicoplanif> tecnicoplanifList) {
		for (Tecnicoplanif  tecnicoplanifAux:tecnicoplanifList) {
			this.tecnicoplanifDao.remove(tecnicoplanifAux);
		}
	}
	
}

