package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.TecnicoEdifDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.TecnicoEdif;

/**
 * TecnicoEdifServiceImpl generated by UDA, 22-dic-2014 10:11:52.
 * 
 * @author UDA
 */

@Service(value = "tecnicoEdifService")
public class TecnicoEdifServiceImpl implements TecnicoEdifService {

	@Autowired
	private TecnicoEdifDao tecnicoEdifDao;

	/**
	 * Inserts a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return TecnicoEdif
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TecnicoEdif add(TecnicoEdif tecnicoEdif) {
		return this.tecnicoEdifDao.add(tecnicoEdif);
	}

	/**
	 * Updates a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return TecnicoEdif
	 */
	@Transactional(rollbackFor = Throwable.class)
	public TecnicoEdif update(TecnicoEdif tecnicoEdif) {
		return this.tecnicoEdifDao.update(tecnicoEdif);
	}

	/**
	 * Finds a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return TecnicoEdif
	 */
	public TecnicoEdif find(TecnicoEdif tecnicoEdif) {
		return (TecnicoEdif) this.tecnicoEdifDao.find(tecnicoEdif);
	}

	/**
	 * Finds a List of rows in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<TecnicoEdif> findAll(TecnicoEdif tecnicoEdif,
			Pagination pagination) {
		return (List<TecnicoEdif>) this.tecnicoEdifDao.findAll(tecnicoEdif,
				pagination);
	}

	/**
	 * Counts rows in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return Long
	 */
	public Long findAllCount(TecnicoEdif tecnicoEdif) {
		return this.tecnicoEdifDao.findAllCount(tecnicoEdif);
	}

	/**
	 * Finds rows in the TecnicoEdif table using like.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<TecnicoEdif> findAllLike(TecnicoEdif tecnicoEdif,
			Pagination pagination, Boolean startsWith) {
		return (List<TecnicoEdif>) this.tecnicoEdifDao.findAllLike(tecnicoEdif,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the TecnicoEdif table using like.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(TecnicoEdif tecnicoEdif, Boolean startsWith) {
		return this.tecnicoEdifDao.findAllLikeCount(tecnicoEdif, startsWith);
	}

	/**
	 * Deletes a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(TecnicoEdif tecnicoEdif) {
		this.tecnicoEdifDao.remove(tecnicoEdif);
	}

	/**
	 * Deletes a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void quitarEdificioATecnico(TecnicoEdif tecnicoEdif) {
		this.tecnicoEdifDao.quitarEdificioATecnico(tecnicoEdif);
	}

	/**
	 * Deletes multiple rows in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdifList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<TecnicoEdif> tecnicoEdifList) {
		for (TecnicoEdif tecnicoEdifAux : tecnicoEdifList) {
			this.tecnicoEdifDao.remove(tecnicoEdifAux);
		}
	}

	/**
	 * Finds a List of rows in the TecnicoEdif table.
	 * 
	 * @param idTecnico
	 *            Long
	 * @param idEdificio
	 *            String
	 * @return List
	 */
	public List<TecnicoEdif> comprobarTecnicoZonasEdificio(Long idTecnico,
			String idEdificio) {
		return (List<TecnicoEdif>) this.tecnicoEdifDao
				.comprobarTecnicoZonasEdificio(idTecnico, idEdificio);
	}
}
