package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.TecnicoEdif;

/**
 * TecnicoEdifService generated by UDA, 22-dic-2014 10:11:52.
 * 
 * @author UDA
 */

public interface TecnicoEdifService {

	/**
	 * Inserts a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return TecnicoEdif
	 */
	TecnicoEdif add(TecnicoEdif tecnicoEdif);

	/**
	 * Updates a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return TecnicoEdif
	 */
	TecnicoEdif update(TecnicoEdif tecnicoEdif);

	/**
	 * Finds a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return TecnicoEdif
	 */
	TecnicoEdif find(TecnicoEdif tecnicoEdif);

	/**
	 * Finds a List of rows in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<TecnicoEdif> findAll(TecnicoEdif tecnicoEdif, Pagination pagination);

	/**
	 * Counts rows in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return Long
	 */
	Long findAllCount(TecnicoEdif tecnicoEdif);

	/**
	 * Finds rows in the TecnicoEdif table using like.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<TecnicoEdif> findAllLike(TecnicoEdif tecnicoEdif,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the TecnicoEdif table using like.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(TecnicoEdif tecnicoEdif, Boolean startsWith);

	/**
	 * Deletes a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return
	 */
	void remove(TecnicoEdif tecnicoEdif);

	/**
	 * Deletes a single row in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return
	 */
	void quitarEdificioATecnico(TecnicoEdif tecnicoEdif);

	/**
	 * Deletes multiple rows in the TecnicoEdif table.
	 * 
	 * @param tecnicoEdifList
	 *            List
	 * @return
	 */
	void removeMultiple(List<TecnicoEdif> tecnicoEdifList);

	/**
	 * Finds a List of rows in the TecnicoEdif table.
	 * 
	 * @param idTecnico
	 *            Long
	 * @param idEdificio
	 *            String
	 * @return List
	 */
	List<TecnicoEdif> comprobarTecnicoZonasEdificio(Long idTecnico,
			String idEdificio);

}
