package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.ServiciosDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Servicios;

/**
 * ServiciosServiceImpl generated by UDA, 16-sep-2015 9:53:11.
 * 
 * @author UDA
 */

@Service(value = "serviciosService")
public class ServiciosServiceImpl implements ServiciosService {

	@Autowired
	private ServiciosDao serviciosDao;

	/**
	 * Inserts a single row in the Servicios table.
	 * 
	 * @param servicios
	 *            Servicios
	 * @return Servicios
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Servicios add(Servicios servicios) {
		return this.serviciosDao.add(servicios);
	}

	/**
	 * Updates a single row in the Servicios table.
	 * 
	 * @param servicios
	 *            Servicios
	 * @return Servicios
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Servicios update(Servicios servicios) {
		return this.serviciosDao.update(servicios);
	}

	/**
	 * Finds a single row in the Servicios table.
	 * 
	 * @param servicios
	 *            Servicios
	 * @return Servicios
	 */
	public Servicios find(Servicios servicios) {
		return (Servicios) this.serviciosDao.find(servicios);
	}

	/**
	 * Finds a List of rows in the Servicios table.
	 * 
	 * @param servicios
	 *            Servicios
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Servicios> findAll(Servicios servicios, Pagination pagination) {
		return (List<Servicios>) this.serviciosDao.findAll(servicios,
				pagination);
	}

	/**
	 * Finds a List of rows in the Servicios table.
	 * 
	 * @param servicios
	 *            Servicios
	 * @return List
	 */
	public List<Servicios> obtenerServiciosNoCero(Servicios servicios) {
		return (List<Servicios>) this.serviciosDao
				.obtenerServiciosNoCero(servicios);
	}

	/**
	 * Counts rows in the Servicios table.
	 * 
	 * @param servicios
	 *            Servicios
	 * @return Long
	 */
	public Long findAllCount(Servicios servicios) {
		return this.serviciosDao.findAllCount(servicios);
	}

	/**
	 * Finds rows in the Servicios table using like.
	 * 
	 * @param servicios
	 *            Servicios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Servicios> findAllLike(Servicios servicios,
			Pagination pagination, Boolean startsWith) {
		return (List<Servicios>) this.serviciosDao.findAllLike(servicios,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Servicios table using like.
	 * 
	 * @param servicios
	 *            Servicios
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Servicios servicios, Boolean startsWith) {
		return this.serviciosDao.findAllLikeCount(servicios, startsWith);
	}

	/**
	 * Deletes a single row in the Servicios table.
	 * 
	 * @param servicios
	 *            Servicios
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Servicios servicios) {
		this.serviciosDao.remove(servicios);
	}

	/**
	 * Deletes multiple rows in the Servicios table.
	 * 
	 * @param serviciosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Servicios> serviciosList) {
		for (Servicios serviciosAux : serviciosList) {
			this.serviciosDao.remove(serviciosAux);
		}
	}
}
