package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.RolesMovilDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.RolesMovil;

/**
 * RolesServiceImpl
 * 
 * @author VDIAZSAN
 */

@Service(value = "rolesMovilService")
public class RolesMovilServiceImpl implements RolesMovilService {

	@Autowired
	private RolesMovilDao rolesMovilDao;

	/**
	 * Inserts a single row in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @return RolesMovil
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RolesMovil add(RolesMovil rolesMovil) {
		return this.rolesMovilDao.add(rolesMovil);
	}

	/**
	 * Updates a single row in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @return RolesMovil
	 */
	@Transactional(rollbackFor = Throwable.class)
	public RolesMovil update(RolesMovil rolesMovil) {

		RolesMovil rolAct = this.rolesMovilDao.update(rolesMovil);

		return rolAct;
	}

	/**
	 * Finds a single row in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @return RolesMovil
	 */
	public RolesMovil find(RolesMovil rolesMovil) {
		return (RolesMovil) this.rolesMovilDao.find(rolesMovil);
	}

	public RolesMovil findByRolGmao(RolesMovil rolesMovil) {
		return (RolesMovil) this.rolesMovilDao.findByRolGmao(rolesMovil);
	}

	/**
	 * Finds a List of rows in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<RolesMovil> findAll(RolesMovil rolesMovil, Pagination pagination) {
		return (List<RolesMovil>) this.rolesMovilDao.findAll(rolesMovil,
				pagination);
	}

	/**
	 * Counts rows in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @return Long
	 */
	public Long findAllCount(RolesMovil rolesMovil) {
		return this.rolesMovilDao.findAllCount(rolesMovil);
	}

	/**
	 * Finds rows in the RolesMovil table using like.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<RolesMovil> findAllLike(RolesMovil rolesMovil,
			Pagination pagination, Boolean startsWith) {
		return (List<RolesMovil>) this.rolesMovilDao.findAllLike(rolesMovil,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the RolesMovil table using like.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(RolesMovil rolesMovil, Boolean startsWith) {
		return this.rolesMovilDao.findAllLikeCount(rolesMovil, startsWith);
	}

	/**
	 * Deletes a single row in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(RolesMovil rolesMovil) {
		this.rolesMovilDao.remove(rolesMovil);
	}

	/**
	 * Deletes multiple rows in the RolesMovil table.
	 * 
	 * @param rolesList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<RolesMovil> rolesMovilList) {
		for (RolesMovil rolesMovilAux : rolesMovilList) {
			this.rolesMovilDao.remove(rolesMovilAux);
		}
	}

}
