package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.RolesMovil;

/**
 * RolesServicef
 * 
 * @author VDIAZSAN
 */

public interface RolesMovilService {

	/**
	 * Inserts a single row in the RolesMovil table.
	 * 
	 * @param RolesMovil
	 *            RolesMovil
	 * @return RolesMovil
	 */
	RolesMovil add(RolesMovil rolesMovil);

	/**
	 * Updates a single row in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @return RolesMovil
	 */
	RolesMovil update(RolesMovil rolesMovil);

	/**
	 * Finds a single row in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @return RolesMovil
	 */
	RolesMovil find(RolesMovil rolesMovil);

	RolesMovil findByRolGmao(RolesMovil rolesMovil);

	/**
	 * Finds a List of rows in the RolesMovil table.
	 * 
	 * @param RolesMovil
	 *            RolesMovil
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<RolesMovil> findAll(RolesMovil rolesMovil, Pagination pagination);

	/**
	 * Counts rows in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @return Long
	 */
	Long findAllCount(RolesMovil rolesMovil);

	/**
	 * Finds rows in the Roles table using like.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<RolesMovil> findAllLike(RolesMovil rolesMovil, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the RolesMovil table using like.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(RolesMovil rolesMovil, Boolean startsWith);

	/**
	 * Deletes a single row in the RolesMovil table.
	 * 
	 * @param rolesMovil
	 *            RolesMovil
	 * @return
	 */
	void remove(RolesMovil rolesMovil);

	/**
	 * Deletes multiple rows in the RolesMovil table.
	 * 
	 * @param rolesList
	 *            List
	 * @return
	 */
	void removeMultiple(List<RolesMovil> rolesList);

}
