package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.PresenciaDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Presencia;

/**
 * PresenciaServiceImpl generated by UDA, 30-abr-2015 12:52:59.
 * 
 * @author UDA
 */

@Service(value = "presenciaService")
public class PresenciaServiceImpl implements PresenciaService {

	@Autowired
	private PresenciaDao presenciaDao;

	/**
	 * Inserts a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Presencia add(Presencia presencia) {
		return this.presenciaDao.add(presencia);
	}

	/**
	 * Updates a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Presencia update(Presencia presencia) {
		return this.presenciaDao.update(presencia);
	}

	/**
	 * Finds a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	public Presencia find(Presencia presencia) {
		return (Presencia) this.presenciaDao.find(presencia);
	}

	/**
	 * Finds a List of rows in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Presencia> findAll(Presencia presencia, Pagination pagination) {
		return (List<Presencia>) this.presenciaDao.findAll(presencia,
				pagination);
	}

	/**
	 * Counts rows in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Long
	 */
	public Long findAllCount(Presencia presencia) {
		return this.presenciaDao.findAllCount(presencia);
	}

	/**
	 * Finds rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Presencia> findAllLike(Presencia presencia,
			Pagination pagination, Boolean startsWith) {
		return (List<Presencia>) this.presenciaDao.findAllLike(presencia,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Presencia presencia, Boolean startsWith) {
		return this.presenciaDao.findAllLikeCount(presencia, startsWith);
	}

	/**
	 * Deletes a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Presencia presencia) {
		this.presenciaDao.remove(presencia);
	}

	/**
	 * Deletes multiple rows in the Presencia table.
	 * 
	 * @param presenciaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Presencia> presenciaList) {
		for (Presencia presenciaAux : presenciaList) {
			this.presenciaDao.remove(presenciaAux);
		}
	}

	/**
	 * Comprobar si el tecnico esta presente
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Boolean
	 */
	public Boolean comprobarTecnicoEstaPresente(Presencia presencia) {
		return this.presenciaDao.comprobarTecnicoEstaPresente(presencia);
	}

	/**
	 * Finds rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Presencia> obtenerPresencias(Presencia presencia,
			Pagination pagination, Boolean startsWith) {
		return (List<Presencia>) this.presenciaDao.obtenerPresencias(presencia,
				pagination, startsWith);
	}

	public Presencia obtenerFechaPresente(Presencia presencia) {
		return this.presenciaDao.tecnicoEstaPresente(presencia);
	}

	/**
	 * Counts rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long obtenerPresenciasCount(Presencia presencia, Boolean startsWith) {
		return this.presenciaDao.obtenerPresenciasCount(presencia, startsWith);
	}

	/**
	 * Inserts a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Presencia nuevaPresencia(Presencia presencia) {

		// Damos de alta la nueva presencia
		Presencia presenciaNueva = this.presenciaDao.add(presencia);

		// cerramos la presencia anterior (THASTA=0) si existe
		// obtener el idPresencia anterior
		Presencia presenciaAnterior = this.presenciaDao
				.obtenerPresenciaAnterior(presenciaNueva);

		if (presenciaAnterior != null) {
			// Cerrar esa presencia
			if (presenciaAnterior.getThasta() != null
					&& presenciaAnterior.getThasta().equals("5")) {
				// Si la anterior es de MovilGmao mantenemos el 5 en el campo
				// thasta para diferenciarla
				this.presenciaDao.cerrarAnteriorMovil(presenciaAnterior);
			} else {
				this.presenciaDao.cerrarAnterior(presenciaAnterior);
			}
		}
		return presenciaNueva;
	}
}
