package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Presencia;

/**
 * PresenciaService generated by UDA, 30-abr-2015 12:52:59.
 * 
 * @author UDA
 */

public interface PresenciaService {

	/**
	 * Inserts a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	Presencia add(Presencia presencia);

	/**
	 * Updates a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	Presencia update(Presencia presencia);

	/**
	 * Finds a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	Presencia find(Presencia presencia);

	/**
	 * Finds a List of rows in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Presencia> findAll(Presencia presencia, Pagination pagination);

	/**
	 * Counts rows in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Long
	 */
	Long findAllCount(Presencia presencia);

	/**
	 * Finds rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Presencia> findAllLike(Presencia presencia, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Presencia presencia, Boolean startsWith);

	/**
	 * Deletes a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return
	 */
	void remove(Presencia presencia);

	/**
	 * Deletes multiple rows in the Presencia table.
	 * 
	 * @param presenciaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Presencia> presenciaList);

	/**
	 * Comprobar si el tecnico esta presente
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Boolean
	 */

	public Boolean comprobarTecnicoEstaPresente(Presencia presencia);

	/**
	 * Finds rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Presencia> obtenerPresencias(Presencia presencia,
			Pagination pagination, Boolean startsWith);

	public Presencia obtenerFechaPresente(Presencia presencia);

	/**
	 * Counts rows in the Presencia table using like.
	 * 
	 * @param presencia
	 *            Presencia
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long obtenerPresenciasCount(Presencia presencia, Boolean startsWith);

	/**
	 * Inserts a single row in the Presencia table.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	Presencia nuevaPresencia(Presencia presencia);
}
