package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.PlantasDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Plantas;

/**
 * PlantasServiceImpl generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

@Service(value = "plantasService")
public class PlantasServiceImpl implements PlantasService {

	@Autowired
	private PlantasDao plantasDao;

	/**
	 * Inserts a single row in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return Plantas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Plantas add(Plantas plantas) {
		return this.plantasDao.add(plantas);
	}

	/**
	 * Updates a single row in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return Plantas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Plantas update(Plantas plantas) {
		return this.plantasDao.update(plantas);
	}

	/**
	 * Finds a single row in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return Plantas
	 */
	public Plantas find(Plantas plantas) {
		return (Plantas) this.plantasDao.find(plantas);
	}

	/**
	 * Finds a single row in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return Plantas
	 */
	public Plantas obtenerPlanta(Plantas plantas) {
		return (Plantas) this.plantasDao.obtenerPlanta(plantas);
	}

	/**
	 * Finds a List of rows in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Plantas> findAll(Plantas plantas, Pagination pagination) {
		return (List<Plantas>) this.plantasDao.findAll(plantas, pagination);
	}

	/**
	 * Obtener Plantas para el edificio y zona especificado.
	 * 
	 * @param codEdif
	 *            String
	 * @param codZona
	 *            Integer
	 * @return List
	 */
	public List<Plantas> obtenerPlantasEdifZona(String codEdif, Integer codZona) {
		return (List<Plantas>) this.plantasDao.obtenerPlantasEdifZona(codEdif,
				codZona);
	}

	public List<Plantas> obtenerPlantasEdifZonaAlta(String codEdif,
			Integer codZona) {
		return (List<Plantas>) this.plantasDao.obtenerPlantasEdifZonaAlta(
				codEdif, codZona);
	}

	/**
	 * Obtener Plantas para el edificio y zona especificado.
	 * 
	 * @param codEdif
	 *            String
	 * @param codZona
	 *            Integer
	 * @return List
	 */
	public List<Plantas> obtenerPlantasEdifZonaConPlanos(String codEdif,
			Integer codZona) {
		return (List<Plantas>) this.plantasDao.obtenerPlantasEdifZonaConPlanos(
				codEdif, codZona);
	}

	/**
	 * Counts rows in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return Long
	 */
	public Long findAllCount(Plantas plantas) {
		return this.plantasDao.findAllCount(plantas);
	}

	/**
	 * Finds rows in the Plantas table using like.
	 * 
	 * @param plantas
	 *            Plantas
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Plantas> findAllLike(Plantas plantas, Pagination pagination,
			Boolean startsWith) {
		return (List<Plantas>) this.plantasDao.findAllLike(plantas, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Plantas table using like.
	 * 
	 * @param plantas
	 *            Plantas
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Plantas plantas, Boolean startsWith) {
		return this.plantasDao.findAllLikeCount(plantas, startsWith);
	}

	/**
	 * Deletes a single row in the Plantas table.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Plantas plantas) {
		this.plantasDao.remove(plantas);
	}

	/**
	 * Deletes multiple rows in the Plantas table.
	 * 
	 * @param plantasList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Plantas> plantasList) {
		for (Plantas plantasAux : plantasList) {
			this.plantasDao.remove(plantasAux);
		}
	}

	public List<Plantas> obtenerPlantasZonaLibres(String codEdificio,
			String codZona, String language) {
		return this.plantasDao.obtenerPlantasZonaLibres(codEdificio, codZona,
				language);
	}

	public List<Plantas> obtenerPlantasZonaOcupadas(String codEdificio,
			String codZona, String language) {
		return this.plantasDao.obtenerPlantasZonaOcupadas(codEdificio, codZona,
				language);
	}

	public Plantas obtenerPlantaDesdeXlnets(Plantas plantas) {
		return this.plantasDao.obtenerPlantaDesdeXlnets(plantas);
	}

}
