package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.PlanosDao;
import com.ejie.x38.dto.Jerarquia;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import java.util.TreeMap;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Planos;

/**
 * PlanosServiceImpl generated by UDA, 12-ene-2015 16:12:00.
 * 
 * @author UDA
 */

@Service(value = "planosService")
public class PlanosServiceImpl implements PlanosService {

	@Autowired
	private PlanosDao planosDao;

	/**
	 * Inserts a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Planos add(Planos planos) {
		return this.planosDao.add(planos);
	}

	/**
	 * Inserts a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Planos nuevoPlano(Planos planos) {
		return this.planosDao.nuevoPlano(planos);
	}

	/**
	 * Updates a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Planos update(Planos planos) {
		return this.planosDao.update(planos);
	}

	/**
	 * Updates a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Planos asociarPadreHijo(Planos planos) {
		return this.planosDao.asociarPadreHijo(planos);
	}

	/**
	 * Finds a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	public Planos find(Planos planos) {
		return (Planos) this.planosDao.find(planos);
	}

	/**
	 * Finds a List of rows in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Planos> findAll(Planos planos, Pagination pagination) {
		return (List<Planos>) this.planosDao.findAll(planos, pagination);
	}

	/**
	 * Obtener lista de planos para un edificio, zona y planta dado.
	 * 
	 * @param codEdif
	 *            String
	 * @param codPlanta
	 *            Integer
	 * @param codZona
	 *            Integer
	 * @return List
	 */
	public List<Planos> obtenerListaPlanos(String codEdif, Integer codPlanta,
			Integer codZona) {
		return (List<Planos>) this.planosDao.obtenerListaPlanos(codEdif,
				codPlanta, codZona);
	}

	public byte[] buscaDibujo(Planos plano, String idioma) {
		return this.planosDao.buscaDibujo(plano, idioma);

	}

	/**
	 * Counts rows in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Long
	 */
	public Long findAllCount(Planos planos) {
		return this.planosDao.findAllCount(planos);
	}

	/**
	 * Finds rows in the Planos table using like.
	 * 
	 * @param planos
	 *            Planos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Planos> findAllLike(Planos planos, Pagination pagination,
			Boolean startsWith) {
		return (List<Planos>) this.planosDao.findAllLike(planos, pagination,
				startsWith);
	}

	/**
	 * Finds rows in the Planos table using like.
	 * 
	 * @param planos
	 *            Planos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Planos> obtenerPlanos(Planos planos, Pagination pagination,
			Boolean startsWith) {
		return (List<Planos>) this.planosDao.obtenerPlanos(planos, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Planos table using like.
	 * 
	 * @param planos
	 *            Planos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Planos planos, Boolean startsWith) {
		return this.planosDao.findAllLikeCount(planos, startsWith);
	}

	/**
	 * Counts rows in the Planos table using like.
	 * 
	 * @param planos
	 *            Planos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long obtenerPlanosCount(Planos planos, Boolean startsWith) {
		return this.planosDao.obtenerPlanosCount(planos, startsWith);
	}

	/**
	 * Deletes a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Planos planos) {
		this.planosDao.remove(planos);
	}

	/**
	 * Deletes multiple rows in the Planos table.
	 * 
	 * @param planosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Planos> planosList) {
		for (Planos planosAux : planosList) {
			this.planosDao.remove(planosAux);
		}
	}

	/**
	 * Finds a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	public Planos obtenerPlano(Planos planos) {
		return (Planos) this.planosDao.obtenerPlano(planos);
	}

	/**
	 * Modifica el dibujo de un Plano.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Planos modificaDibujoPlano(Planos planos) {
		return this.planosDao.modificaDibujoPlano(planos);
	}

	public TreeMap<String, TreeMap<String, String>> obtenerPlanosSelect(
			Planos planoJerarquia, Pagination pagination) {
		return this.planosDao.obtenerPlanosSelect(planoJerarquia, pagination);
	}

	/**
	 * Finds rows in the Planos table using like.
	 * 
	 * @param planos
	 *            Planos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Jerarquia<Planos>> obtenerPlanosJerarquia(Planos planos,
			Pagination pagination, Boolean startsWith) {
		return (List<Jerarquia<Planos>>) this.planosDao.obtenerPlanosJerarquia(
				planos, pagination, startsWith);
	}

	/**
	 * Counts rows in the Planos table using like.
	 * 
	 * @param planos
	 *            Planos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long obtenerPlanosJerarquiaCount(Planos planos, Boolean startsWith,
			Pagination pagination) {
		return this.planosDao.obtenerPlanosJerarquiaCount(planos, startsWith,
				pagination);
	}
}
