package com.ejie.aa20b.service;

import com.ejie.x38.dto.Jerarquia;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import java.util.TreeMap;

import com.ejie.aa20b.model.Planos;

/**
 * PlanosService generated by UDA, 12-ene-2015 16:12:00.
 * 
 * @author UDA
 */

public interface PlanosService {

	/**
	 * Inserts a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	Planos add(Planos planos);

	/**
	 * Inserts a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	Planos nuevoPlano(Planos planos);

	/**
	 * Updates a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	Planos update(Planos planos);

	/**
	 * Updates a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	Planos asociarPadreHijo(Planos planos);

	/**
	 * Modifica el dibujo de um plano.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	Planos modificaDibujoPlano(Planos planos);

	/**
	 * Finds a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	Planos find(Planos planos);

	/**
	 * Finds a List of rows in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Planos> findAll(Planos planos, Pagination pagination);

	/**
	 * Obtener lista de planos para un edificio, zona y planta dado.
	 * 
	 * @param codEdif
	 *            String
	 * @param codPlanta
	 *            Integer
	 * @param codZona
	 *            Integer
	 * @return List
	 */
	List<Planos> obtenerListaPlanos(String codEdif, Integer codPlanta,
			Integer codZona);

	byte[] buscaDibujo(Planos plano, String idioma);

	/**
	 * Counts rows in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Long
	 */
	Long findAllCount(Planos planos);

	/**
	 * Finds rows in the Planos table using like.
	 * 
	 * @param planos
	 *            Planos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Planos> findAllLike(Planos planos, Pagination pagination,
			Boolean startsWith);

	/**
	 * Finds rows in the Planos table using like.
	 * 
	 * @param planos
	 *            Planos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Planos> obtenerPlanos(Planos planos, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Planos table using like.
	 * 
	 * @param planos
	 *            Planos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Planos planos, Boolean startsWith);

	/**
	 * Counts rows in the Planos table using like.
	 * 
	 * @param planos
	 *            Planos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long obtenerPlanosCount(Planos planos, Boolean startsWith);

	/**
	 * Deletes a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return
	 */
	void remove(Planos planos);

	/**
	 * Deletes multiple rows in the Planos table.
	 * 
	 * @param planosList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Planos> planosList);

	/**
	 * Finds a single row in the Planos table.
	 * 
	 * @param planos
	 *            Planos
	 * @return Planos
	 */
	Planos obtenerPlano(Planos planos);

	TreeMap<String, TreeMap<String, String>> obtenerPlanosSelect(
			Planos PlanoJerarquia, Pagination pagination);

	/**
	 * Counts rows in the Planos table using like.
	 * 
	 * @param planos
	 *            Planos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long obtenerPlanosJerarquiaCount(Planos planos, Boolean startsWith,
			Pagination pagination);

	/**
	 * Finds rows in the Planos table using like.
	 * 
	 * @param planos
	 *            Planos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Jerarquia<Planos>> obtenerPlanosJerarquia(Planos planos,
			Pagination pagination, Boolean startsWith);
}
