package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.PartetecnicosDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Partetecnicos;

/**
 * PartetecnicosServiceImpl generated by UDA, 22-dic-2014 10:11:52.
 * 
 * @author UDA
 */

@Service(value = "partetecnicosService")
public class PartetecnicosServiceImpl implements PartetecnicosService {

	@Autowired
	private PartetecnicosDao partetecnicosDao;

	/**
	 * Inserts a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partetecnicos add(Partetecnicos partetecnicos) {
		return this.partetecnicosDao.add(partetecnicos);
	}

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partetecnicos update(Partetecnicos partetecnicos) {
		return this.partetecnicosDao.update(partetecnicos);
	}

	/**
	 * Finalizar/Abrir parte tecnico.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partetecnicos finalizarParteTec(Partetecnicos partetecnicos) {
		return this.partetecnicosDao.finalizarParteTec(partetecnicos);
	}

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partetecnicos guardarNotas(Partetecnicos partetecnicos) {
		return this.partetecnicosDao.guardarNotas(partetecnicos);
	}

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partetecnicos guardarNotasTecnico(Partetecnicos partetecnicos) {
		return this.partetecnicosDao.guardarNotasTecnico(partetecnicos);
	}

	/**
	 * Finds a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	public Partetecnicos find(Partetecnicos partetecnicos) {
		return (Partetecnicos) this.partetecnicosDao.find(partetecnicos);
	}

	/**
	 * Finds a List of rows in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Partetecnicos> findAll(Partetecnicos partetecnicos,
			Pagination pagination) {
		return (List<Partetecnicos>) this.partetecnicosDao.findAll(
				partetecnicos, pagination);
	}

	/**
	 * Finds a List of rows in the Partetecnicos table.
	 * 
	 * @param pagination
	 *            Pagination
	 * @param idParte
	 *            Integer
	 * @return List
	 */
	public List<Partetecnicos> tecnicosParteGrid(Pagination pagination,
			Integer idParte) {
		return (List<Partetecnicos>) this.partetecnicosDao.tecnicosParteGrid(
				pagination, idParte);
	}

	/**
	 * Counts rows in the Partetecnicos table using like.
	 * 
	 * @param idParte
	 *            Integer
	 * @return Long
	 */
	public Long tecnicosParteGridCount(Integer idParte) {
		return this.partetecnicosDao.tecnicosParteGridCount(idParte);
	}

	/**
	 * Obtener tecnicos asociados a un parte.
	 * 
	 * @param idParte
	 *            Integer
	 * @return List
	 */
	public List<Partetecnicos> obtenerTecnicosParteAsociados(Integer idParte) {
		return (List<Partetecnicos>) this.partetecnicosDao
				.obtenerTecnicosParteAsociados(idParte);
	}

	/**
	 * Counts rows in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Long
	 */
	public Long findAllCount(Partetecnicos partetecnicos) {
		return this.partetecnicosDao.findAllCount(partetecnicos);
	}

	/**
	 * Finds rows in the Partetecnicos table using like.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Partetecnicos> findAllLike(Partetecnicos partetecnicos,
			Pagination pagination, Boolean startsWith) {
		return (List<Partetecnicos>) this.partetecnicosDao.findAllLike(
				partetecnicos, pagination, startsWith);
	}

	/**
	 * Counts rows in the Partetecnicos table using like.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Partetecnicos partetecnicos, Boolean startsWith) {
		return this.partetecnicosDao
				.findAllLikeCount(partetecnicos, startsWith);
	}

	/**
	 * Deletes a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Partetecnicos partetecnicos) {
		this.partetecnicosDao.remove(partetecnicos);
	}

	/**
	 * Eliminar un tecnico asociado a un parte.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void eliminaTecnicoParte(Partetecnicos partetecnicos) {
		this.partetecnicosDao.eliminaTecnicoParte(partetecnicos);
	}

	/**
	 * Deletes multiple rows in the Partetecnicos table.
	 * 
	 * @param partetecnicosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Partetecnicos> partetecnicosList) {
		for (Partetecnicos partetecnicosAux : partetecnicosList) {
			this.partetecnicosDao.remove(partetecnicosAux);
		}
	}

	/**
	 * marcar enviomail a single row in the Partetecnicos table.
	 * 
	 * @param idParte
	 *            Integer
	 * @param idTecnico
	 *            Long
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void marcarEnvioMail(Integer idParte, Long idTecnico) {
		this.partetecnicosDao.marcarEnvioMail(idParte, idTecnico);
	}
}
