package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Partetecnicos;

/**
 * PartetecnicosService generated by UDA, 22-dic-2014 10:11:52.
 * 
 * @author UDA
 */

public interface PartetecnicosService {

	/**
	 * Inserts a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	Partetecnicos add(Partetecnicos partetecnicos);

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	Partetecnicos update(Partetecnicos partetecnicos);

	/**
	 * Finalizar/abrir parte tecnico.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	Partetecnicos finalizarParteTec(Partetecnicos partetecnicos);

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	Partetecnicos guardarNotas(Partetecnicos partetecnicos);

	/**
	 * Updates a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	Partetecnicos guardarNotasTecnico(Partetecnicos partetecnicos);

	/**
	 * Finds a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	Partetecnicos find(Partetecnicos partetecnicos);

	/**
	 * Finds a List of rows in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Partetecnicos> findAll(Partetecnicos partetecnicos,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Partetecnicos table.
	 * 
	 * @param pagination
	 *            Pagination
	 * @param idParte
	 *            Integer
	 * @return List
	 */
	List<Partetecnicos> tecnicosParteGrid(Pagination pagination, Integer idParte);

	/**
	 * Counts rows in the Partetecnicos table.
	 * 
	 * @param idParte
	 *            Integer
	 * @return Long
	 */
	Long tecnicosParteGridCount(Integer idParte);

	/**
	 * Obtener tecnicos asociados a un parte.
	 * 
	 * @param idParte
	 *            Integer
	 * @return List
	 */
	List<Partetecnicos> obtenerTecnicosParteAsociados(Integer idParte);

	/**
	 * Counts rows in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Long
	 */
	Long findAllCount(Partetecnicos partetecnicos);

	/**
	 * Finds rows in the Partetecnicos table using like.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Partetecnicos> findAllLike(Partetecnicos partetecnicos,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Partetecnicos table using like.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Partetecnicos partetecnicos, Boolean startsWith);

	/**
	 * Deletes a single row in the Partetecnicos table.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return
	 */
	void remove(Partetecnicos partetecnicos);

	/**
	 * Eliminar un tecnico asociado a un parte.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return
	 */
	public void eliminaTecnicoParte(Partetecnicos partetecnicos);

	/**
	 * Deletes multiple rows in the Partetecnicos table.
	 * 
	 * @param partetecnicosList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Partetecnicos> partetecnicosList);

	/**
	 * marcar enviomail a single row in the Partetecnicos table.
	 * 
	 * @param idParte
	 *            Integer
	 * @param idTecnico
	 *            Long
	 * @return
	 */
	public void marcarEnvioMail(Integer idParte, Long idTecnico);
}
