package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.ActuacionDao;
import com.ejie.aa20b.dao.ParteplanoDao;
import com.ejie.aa20b.dao.PartesDao;
import com.ejie.aa20b.dao.PartetecnicosDao;
import com.ejie.x38.dto.Pagination;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.activation.DataHandler;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Parteplano;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Usuarios;

/**
 * PartesServiceImpl generated by UDA, 28-nov-2014 11:59:04.
 * 
 * @author UDA
 */

@Service(value = "partesService")
public class PartesServiceImpl implements PartesService {

	@Autowired
	private PartesDao partesDao;

	@Autowired
	private PartetecnicosDao parteTecnicosDao;

	@Autowired
	private Aa20bUsuarioXLNETService usuarioXLNETService;

	@Autowired
	private ActuacionService actuacionService;

	@Autowired
	private ActuacionDao actuacionDao;

	@Autowired
	private ParteplanoDao parteplanoDao;

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private ParteplanoService parteplanoService;

	/**
	 * Inserts a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partes add(Partes partes) {
		return this.partesDao.add(partes);
	}

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partes update(Partes partes) {
		return this.partesDao.update(partes);
	}

	@Transactional(rollbackFor = Throwable.class)
	public Partes actualizarFechaPlanificacion(Partes partes) {
		return this.partesDao.actualizarFechaPlanificacion(partes);
	}

	@Transactional(rollbackFor = Throwable.class)
	public Partes actualizarInfoNoProcede(Partes partes) {
		return this.partesDao.actualizarInfoNoProcede(partes);
	}

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partes modificarParte(Partes partes) {
		return this.partesDao.modificarParte(partes);
	}

	@Transactional(rollbackFor = Throwable.class)
	public Partes actualizarUUIDparte(Partes partes) {
		return this.partesDao.actualizarUUIDparte(partes);
	}

	/**
	 * Finds a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	public Partes find(Partes partes) {
		return (Partes) this.partesDao.find(partes);
	}

	/**
	 * Finds a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	public Partes findParte(Partes partes) {
		return (Partes) this.partesDao.findParte(partes);
	}

	/**
	 * Finds a List of rows in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Partes> findAll(Partes partes, Pagination pagination) {
		return (List<Partes>) this.partesDao.findAll(partes, pagination);
	}

	public List<Partes> findAllpendientes(Partes partes, Pagination pagination) {
		return (List<Partes>) this.partesDao.findAllpendientes(partes,
				pagination);
	}

	/**
	 * Counts rows in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return Long
	 */
	public Long findAllCount(Partes partes) {
		return this.partesDao.findAllCount(partes);
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Partes> findAllLike(Partes partes, Pagination pagination,
			Boolean startsWith) {
		return (List<Partes>) this.partesDao.findAllLike(partes, pagination,
				startsWith);
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return List
	 */
	public List<Partes> obtenerPartesGrid(Partes partes, Pagination pagination,
			Boolean startsWith, String sUIDUsuario) {
		return (List<Partes>) this.partesDao.obtenerPartesGrid(partes,
				pagination, startsWith, sUIDUsuario);
	}

	public List<Partes> obtenerPartesConsultaUsuNormalGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario) {
		return (List<Partes>) this.partesDao
				.obtenerPartesConsultaUsuNormalGrid(partes, pagination,
						startsWith, sUIDUsuario);
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Partes> obtenerListCorrGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario) {
		return (List<Partes>) this.partesDao.obtenerListCorrGrid(partes,
				pagination, startsWith, sUIDUsuario);
	}

	public List<Partes> obtenerDatosAgendaGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario,
			boolean conTecnicos, List<Tecnicos> listaTecnicosBusq) {
		return (List<Partes>) this.partesDao.obtenerDatosAgendaGrid(partes,
				pagination, startsWith, sUIDUsuario, conTecnicos,
				listaTecnicosBusq);
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Partes> obtenerListEjecTecnicoGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario) {
		return (List<Partes>) this.partesDao.obtenerListEjecTecnicoGrid(partes,
				pagination, startsWith, sUIDUsuario);
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Partes> obtenerListEjecFechaEjGrid(Partes partes,
			Pagination pagination, Boolean startsWith, String sUIDUsuario) {
		return (List<Partes>) this.partesDao.obtenerListEjecFechaEjGrid(partes,
				pagination, startsWith, sUIDUsuario);
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Partes partes, Boolean startsWith) {
		return this.partesDao.findAllLikeCount(partes, startsWith);
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * 
	 * @return Long
	 */
	public Long obtenerPartesGridCount(Partes partes, Boolean startsWith,
			String sUIDUsuario) {
		return this.partesDao.obtenerPartesGridCount(partes, startsWith,
				sUIDUsuario);
	}

	public Long obtenerPartesConsultaUsuNormalGridCount(Partes partes,
			Boolean startsWith, String sUIDUsuario) {
		return this.partesDao.obtenerPartesConsultaUsuNormalGridCount(partes,
				startsWith, sUIDUsuario);
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long obtenerListCorrGridCount(Partes partes, Boolean startsWith,
			String sUIDUsuario) {
		return this.partesDao.obtenerListCorrGridCount(partes, startsWith,
				sUIDUsuario);
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long obtenerListEjecTecnicoGridCount(Partes partes,
			Boolean startsWith, String sUIDUsuario) {
		return this.partesDao.obtenerListEjecTecnicoGridCount(partes,
				startsWith, sUIDUsuario);
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long obtenerListEjecFechaEjGridCount(Partes partes,
			Boolean startsWith, String sUIDUsuario) {
		return this.partesDao.obtenerListEjecFechaEjGridCount(partes,
				startsWith, sUIDUsuario);
	}

	/**
	 * Deletes a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Partes partes) {
		this.partesDao.remove(partes);
	}

	/**
	 * marcar automatica a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void marcarAutomatica(Partes partes) {
		this.partesDao.marcarAutomatica(partes);
	}

	/**
	 * marcar enviomail a single row in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void marcarEnvioMail(Partes partes) {
		this.partesDao.marcarEnvioMail(partes);
	}

	/**
	 * Deletes multiple rows in the Partes table.
	 * 
	 * @param partesList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Partes> partesList) {
		for (Partes partesAux : partesList) {
			this.partesDao.remove(partesAux);
		}
	}

	/**
	 * Finds a List of rows in the Partes table.
	 * 
	 * @param partes
	 *            Partes
	 * @return List
	 */
	public List<Partes> obtenerParte(Partes partes) {
		return (List<Partes>) this.partesDao.obtenerParte(partes);
	}

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param idParte
	 *            Integer
	 * @return Partes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partes finalizarParte(Integer idParte) {
		// Obtener la fecha de ejecucion y el tiempo Real. Fecha Maxima de la
		// tabla de partesTecnicos y suma de tiempo real de todos los tecnicos

		// Obtener tiempo real
		Integer totalTiempo = this.parteTecnicosDao
				.obtenerTiempoEjecucion(idParte);

		Partes parte = new Partes();

		parte.setIdparte(idParte);
		parte.setTiempoReal(totalTiempo);

		// Obtener fecha Maxima

		Partes parteEjec = new Partes();
		parteEjec = this.partesDao.obtenerFechaEjecucion(parte);

		// Si ha finalizado el parte sin ejecución, metemos la fecha actual
		if (parteEjec != null && parteEjec.getFechaej() != null) {
			parte.setFechaej(parteEjec.getFechaej());
		} else {
			parte.setFechaej(new Date());
		}

		// Actualizar el parte con los datos obtenidos
		parte = this.partesDao.finalizarParte(parte);

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		// Enviar email al que ha creado el parte para indicarle que se ha
		// finalizado
		parte = new Partes();
		parte.setIdparte(idParte);
		parte = this.partesDao.findParte(parte);
		if (parte != null && parte.getMail() != null
				&& !parte.getMail().trim().equals("")) {

			// Acceder a los Diccionarios
			Locale loc = LocaleContextHolder.getLocale();
			Locale lCas = new Locale("ES");
			Locale lEus = new Locale("EU");

			String to = "";

			try {

				String variableRemitente = this
						.obtenerVariableCorreo("user.mail.remitente");

				if (variableRemitente == null || variableRemitente == "") {
					String retorno = this.appMessageSource.getMessage(
							"general.email.error", null, loc)
							+ "\n"
							+ this.appMessageSource.getMessage(
									"general.email.noExisteEmisor", null, loc);

				} else {
					String host = this.appConfiguration.getObject()
							.getProperty("servidor.smtp");

					to = parte.getMail();

					String from = variableRemitente;

					Properties props = System.getProperties();
					props.put("mail.smtp.host", host);

					// Esta lÃ­nea indica que vamos a autenticarnos en el
					// servidor
					// SMTP
					// props.put("mail.smtp.auth", "true");
					props.put("mail.smtp.auth", "false");

					// Obtener una sesiÃ³n con las propiedades anteriormente
					// definidas
					// Authenticator auth = new MiAutenticador();
					// Session sesion = Session.getDefaultInstance(props,
					// auth);
					Session sesion = Session.getInstance(props);

					String asunto = "##"
							+ this.appMessageSource.getMessage(
									"partefin.email.asunto", null, lEus)
							+ parte.getIdparte()
							+ " / "
							+ this.appMessageSource.getMessage(
									"partefin.email.asunto", null, lCas)
							+ +parte.getIdparte() + "##";

					StringBuffer contenido = new StringBuffer("<p>"
							+ parte.getIdparte()
							+ " "
							+ this.appMessageSource.getMessage(
									"partefin.email.titulo", null, lEus)
							+ "</p>");

					if (parte.getNoProcede() != null
							&& parte.getNoProcede().equals("1")) {
						if (parte.getObservNoProcede() != null
								&& !parte.getObservNoProcede().equals("")) {
							contenido.append("<p>"
									+ this.appMessageSource.getMessage(
											"partefin.email.motivoNoProcede",
											null, lEus) + " "
									+ parte.getObservNoProcede() + "</p>");
						}
					}

					contenido.append("<p>");

					contenido.append("<u><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.DatosPersonales", null, lEus)
							+ "</b>");
					contenido.append("<br/><b></u>"
							+ this.appMessageSource.getMessage(
									"parte.email.textoNombre", null, lEus)
							+ "</b>");
					contenido.append(" ").append(parte.getNombre());

					contenido.append("<br/><b>"
							+ this.appMessageSource
									.getMessage(
											"parte.email.textoDepartamento",
											null, lEus) + "</b>");
					contenido.append(" ").append(
							parte.getDepartamento().getEdepar());
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.textoDireccion", null, lEus)
							+ "</b>");
					contenido.append(" ")
							.append(parte.getDireccion().getEdir());

					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.telefono", null, lEus)
							+ "</b>");
					contenido.append(" ").append(parte.getTelefo());
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.email", null, lEus) + "</b>");
					contenido.append(" ").append(parte.getMail());
					contenido.append("</p>");
					contenido.append("<p>");
					contenido.append("<u><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.LocAveria", null, lEus)
							+ "</b>");
					contenido.append("<br/><b></u>"
							+ this.appMessageSource.getMessage(
									"parte.email.edificio", null, lEus)
							+ "</b>");
					contenido.append(" ").append(
							parte.getEdificio().getEedificio());
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.planta", null, lEus) + "</b>");
					contenido.append(" ")
							.append(parte.getPlanta().getEplanta());
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.zona", null, lEus) + "</b>");
					contenido.append(" ").append(parte.getZona().getEzona());
					contenido
							.append("<br/><b>"
									+ this.appMessageSource.getMessage(
											"parte.email.espacio", null, lEus)
									+ "</b>");
					contenido.append(" ").append(
							parte.getEspacio().getEespacio());
					contenido.append("</p>");

					contenido.append("<p>");
					contenido.append("<u><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.AveriaDetectada", null, lEus)
							+ "</b>");
					contenido.append("<br/><b></u>"
							+ this.appMessageSource.getMessage(
									"parte.email.clase", null, lEus) + "</b>");
					contenido.append(" ").append(parte.getClase().getEclase());
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.Activo", null, lEus) + "</b>");
					contenido.append(" ")
							.append(parte.getCodigo().getEcodigo());

					contenido.append("</p>");
					contenido.append("<p>");
					contenido.append("<br/><u><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.descParte", null, lEus)
							+ "</b></u>");
					contenido.append(" ").append(
							parte.getObserv() == null ? "" : parte.getObserv());
					contenido.append("</p>");

					contenido.append("<p>"
							+ this.appMessageSource.getMessage(
									"parte.email.despedida", null, lEus)
							+ "</p>");

					contenido.append("<br/>");
					contenido.append("<p style='font-style:italic;'>"
							+ this.appMessageSource.getMessage(
									"parte.email.norespuesta", null, lEus)
							+ "</p>");

					contenido
							.append("___________________________________________________________________________________");

					/* CASTELLANO */
					contenido.append("<p>"
							+ this.appMessageSource.getMessage(
									"partefin.email.titulo", null, lCas) + " "
							+ parte.getIdparte() + "</p>");

					if (parte.getNoProcede() != null
							&& parte.getNoProcede().equals("1")) {
						if (parte.getObservNoProcede() != null
								&& !parte.getObservNoProcede().equals("")) {
							contenido.append("<p>"
									+ this.appMessageSource.getMessage(
											"partefin.email.motivoNoProcede",
											null, lCas) + " "
									+ parte.getObservNoProcede() + "</p>");
						}
					}

					contenido.append("<p>");

					contenido.append("<u><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.DatosPersonales", null, lCas)
							+ "</b>");
					contenido.append("<br/><b></u>"
							+ this.appMessageSource.getMessage(
									"parte.email.textoNombre", null, lCas)
							+ "</b>");
					contenido.append(" ").append(parte.getNombre());

					contenido.append("<br/><b>"
							+ this.appMessageSource
									.getMessage(
											"parte.email.textoDepartamento",
											null, lCas) + "</b>");
					contenido.append(" ").append(
							parte.getDepartamento().getCdepar());
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.textoDireccion", null, lCas)
							+ "</b>");
					contenido.append(" ")
							.append(parte.getDireccion().getCdir());

					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.telefono", null, lCas)
							+ "</b>");
					contenido.append(" ").append(parte.getTelefo());
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.email", null, lCas) + "</b>");
					contenido.append(" ").append(parte.getMail());
					contenido.append("</p>");
					contenido.append("<p>");
					contenido.append("<u><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.LocAveria", null, lCas)
							+ "</b>");
					contenido.append("<br/><b></u>"
							+ this.appMessageSource.getMessage(
									"parte.email.edificio", null, lCas)
							+ "</b>");
					contenido.append(" ").append(
							parte.getEdificio().getCedificio());
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.planta", null, lCas) + "</b>");
					contenido.append(" ")
							.append(parte.getPlanta().getCplanta());
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.zona", null, lCas) + "</b>");
					contenido.append(" ").append(parte.getZona().getCzona());
					contenido
							.append("<br/><b>"
									+ this.appMessageSource.getMessage(
											"parte.email.espacio", null, lCas)
									+ "</b>");
					contenido.append(" ").append(
							parte.getEspacio().getCespacio());
					contenido.append("</p>");

					contenido.append("<p>");
					contenido.append("<u><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.AveriaDetectada", null, lCas)
							+ "</b>");
					contenido.append("<br/><b></u>"
							+ this.appMessageSource.getMessage(
									"parte.email.clase", null, lCas) + "</b>");
					contenido.append(" ").append(parte.getClase().getCclase());
					contenido.append("<br/><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.Activo", null, lCas) + "</b>");
					contenido.append(" ")
							.append(parte.getCodigo().getCcodigo());

					contenido.append("</p>");
					contenido.append("<p>");
					contenido.append("<br/><u><b>"
							+ this.appMessageSource.getMessage(
									"parte.email.descParte", null, lCas)
							+ "</b></u>");
					contenido.append(" ").append(
							parte.getObserv() == null ? "" : parte.getObserv());
					contenido.append("</p>");

					contenido.append("<p>"
							+ this.appMessageSource.getMessage(
									"parte.email.despedida", null, lCas)
							+ "</p>");

					contenido.append("<br/>");
					contenido.append("<p style='font-style:italic;'>"
							+ this.appMessageSource.getMessage(
									"parte.email.norespuesta", null, lCas)
							+ "</p>");

					/**/

					// Obtener el plano si tiene
					Parteplano planoParte = new Parteplano();
					planoParte.setIdparte(parte.getIdparte());

					planoParte = this.parteplanoService.find(planoParte);
					byte[] blobAsBytes = null;
					if (planoParte != null) {
						// Tiene plano
						int blobLeng = (int) planoParte.getDibujo().length();
						blobAsBytes = planoParte.getDibujo().getBytes(1,
								blobLeng);
					}

					// create a message
					MimeMessage msg = new MimeMessage(sesion);
					msg.setFrom(new InternetAddress(from));
					msg.addRecipient(Message.RecipientType.TO,
							new InternetAddress(to));

					// String emailoculto =
					// this.appConfiguration.getObject()
					// .getProperty("emailCopiaOculta");

					String variableEmailOculto = this
							.obtenerVariableCorreo("emailCopiaOculta");

					if (variableEmailOculto != null
							&& !variableEmailOculto.isEmpty())
						msg.addRecipient(Message.RecipientType.BCC,
								new InternetAddress(variableEmailOculto));
					// create and fill the first message part
					MimeBodyPart mbp1 = new MimeBodyPart();

					if (blobAsBytes != null) {
						contenido.append("<img src='cid:planoAveria\'/>");
					}

					// mbp1.setText(contenido.toString());
					mbp1.setContent(contenido.toString(), "text/html");
					// mbp1.setHeader("Content-Type",
					// "text/html; charset=ISO-8859-1");
					Multipart mp = new MimeMultipart();
					mp.addBodyPart(mbp1);

					if (blobAsBytes != null) {
						MimeBodyPart mbp2 = new MimeBodyPart();
						mbp2.setHeader("Content-ID", "<planoAveria>");
						mbp2.setDisposition(MimeBodyPart.INLINE);
						// create the Multipart and add its parts to it
						ByteArrayDataSource source = new ByteArrayDataSource(
								blobAsBytes, "image/jpeg");
						mbp2.setDataHandler(new DataHandler(source));
						mbp2.setFileName("planoParte.png");

						mp.addBodyPart(mbp2);
					}

					// add the Multipart to the message
					msg.setContent(mp);
					msg.setSubject(asunto);

					// set the Date: header
					msg.setSentDate(new Date());

					// send the message
					Transport.send(msg);

					planoParte = null;

				}

			} catch (Exception ex) {
				StackTraceElement[] trazas = ex.getStackTrace();

				StringBuffer retorno = new StringBuffer();
				retorno.append(
						this.appMessageSource.getMessage("general.email.error",
								null, loc))
						.append("\n")
						.append(this.appMessageSource.getMessage(
								"general.email.noExisteEmisor", null, loc));
				retorno.append(" ").append(to);
			}
		}

		return parte;
	}

	/**
	 * Updates a single row in the Partes table.
	 * 
	 * @param idParte
	 *            Integer
	 * @return Partes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partes finalizarParteProceso(Partes parte) {
		// Obtener la fecha de ejecucion y el tiempo Real. Fecha Maxima de la
		// tabla de partesTecnicos y suma de tiempo real de todos los tecnicos

		// Obtener tiempo real
		Integer totalTiempo = this.parteTecnicosDao
				.obtenerTiempoEjecucion(parte.getIdparte());

		parte.setTiempoReal(totalTiempo);

		// Obtener fecha Maxima

		Partes parteEjec = new Partes();
		parteEjec = this.partesDao.obtenerFechaEjecucion(parte);
		if (parteEjec != null && parteEjec.getFechaej() != null) {
			parte.setFechaej(parteEjec.getFechaej());
		}
		// Actualizar el parte con los datos obtenidos

		return this.partesDao.finalizarParte(parte);

	}

	/**
	 * abre el parte padre y todos los hijos (EJECUTADO=0).
	 * 
	 * @param idParte
	 *            Integer
	 * @return Partes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partes abrirParte(Integer idParte) {
		// abre el parte padre y los hijos

		Partes parte = new Partes();
		parte.setIdparte(idParte);

		// Actualizar el parte con los datos obtenidos

		return this.partesDao.abrirParte(parte);

	}

	/**
	 * Crea un parte partiendo de una actuación preventiva.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partes nuevoParteCorrDesdePreventivo(Partes partes) {
		Date fechaHoy = new Date();
		partes.setFechare(fechaHoy);
		partes.setNombre("PREVENTIVO");
		partes.setTelefo("99999");

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETService.obtenerUIDUsuario();
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		partes.setUidPersona(sUIDUsuario);

		Partes parteAux = this.partesDao.nuevoParteCorrDesdePreventivo(partes);

		// Una vez generado el parte se guarda en la Actuacion el número de
		// parte generado.
		Actuacion actuacion = new Actuacion();
		actuacion.setIdactuacion(parteAux.getIdactuac());
		actuacion.setIdparte(parteAux.getIdparte());
		this.actuacionService.actualizarIdparte(actuacion);

		return parteAux;
	}

	/**
	 * Calcula el numero de partes correctivos pendientes de asignar tecnico.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	public Long calculaCorrPendAPT(String UIDUsuario, Integer idServicio,
			Integer idClase) {
		return this.partesDao.calculaCorrPendAPT(UIDUsuario, idServicio,
				idClase);
	}

	/**
	 * Calcula el numero de partes correctivos asignados automaticamente y
	 * pendientes de ejecutar.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	public Long calculaCorrAsigAut(String UIDUsuario, Integer idServicio,
			Integer idClase) {
		return this.partesDao.calculaCorrAsigAut(UIDUsuario, idServicio,
				idClase);
	}

	/**
	 * Calcula el numero de partes correctivos asignados manualmente y
	 * pendientes de ejecutar.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	public Long calculaCorrAsigMan(String UIDUsuario, Integer idServicio,
			Integer idClase) {
		return this.partesDao.calculaCorrAsigMan(UIDUsuario, idServicio,
				idClase);
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	public List<Partes> obtenerCorrPendAsignar(Partes partes,
			Pagination pagination, Boolean startsWith, String UIDUsuario) {
		return (List<Partes>) this.partesDao.obtenerCorrPendAsignar(partes,
				pagination, startsWith, UIDUsuario);
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	public Long obtenerCorrPendAsignarCount(Partes partes, Boolean startsWith,
			String UIDUsuario) {
		return this.partesDao.obtenerCorrPendAsignarCount(partes, startsWith,
				UIDUsuario);
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	public List<Partes> obtenerCorrAut(Partes partes, Pagination pagination,
			Boolean startsWith, String UIDUsuario) {
		return (List<Partes>) this.partesDao.obtenerCorrAut(partes, pagination,
				startsWith, UIDUsuario);
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	public Long obtenerCorrAutCount(Partes partes, Boolean startsWith,
			String UIDUsuario) {
		return this.partesDao.obtenerCorrAutCount(partes, startsWith,
				UIDUsuario);
	}

	/**
	 * Finds rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	public List<Partes> obtenerCorrMan(Partes partes, Pagination pagination,
			Boolean startsWith, String UIDUsuario) {
		return (List<Partes>) this.partesDao.obtenerCorrMan(partes, pagination,
				startsWith, UIDUsuario);
	}

	/**
	 * Counts rows in the Partes table using like.
	 * 
	 * @param partes
	 *            Partes
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	public Long obtenerCorrManCount(Partes partes, Boolean startsWith,
			String UIDUsuario) {
		return this.partesDao.obtenerCorrManCount(partes, startsWith,
				UIDUsuario);
	}

	public ArrayList<TablaInformes> montarSelectTablaCorrPendAsignar(
			String idioma, Partes filtro, String UIDUsuario) {
		return this.partesDao.montarSelectTablaCorrPendAsignar(idioma, filtro,
				UIDUsuario);
	}

	public ArrayList<TablaInformes> montarSelectTablaCorrPendEjecManual(
			String idioma, Partes filtro, String UIDUsuario) {
		return this.partesDao.montarSelectTablaCorrPendEjecManual(idioma,
				filtro, UIDUsuario);
	}

	public ArrayList<TablaInformes> montarSelectTablaCorrPendEjecAuto(
			String idioma, Partes filtro, String UIDUsuario) {
		return this.partesDao.montarSelectTablaCorrPendEjecAuto(idioma, filtro,
				UIDUsuario);
	}

	public ArrayList<TablaInformes> montarSelectTablaCorrectivos(String idioma,
			Partes filtro, String UIDUsuario) {
		return this.partesDao.montarSelectTablaCorrectivos(idioma, filtro,
				UIDUsuario);
	}

	public ArrayList<TablaInformes> montarSelectTablaEjecTecnico(String idioma,
			Partes filtro, String UIDUsuario) {
		return this.partesDao.montarSelectTablaEjecTecnico(idioma, filtro,
				UIDUsuario);
	}

	public ArrayList<TablaInformes> montarSelectTablaEjecFechaEj(String idioma,
			Partes filtro, String UIDUsuario) {
		return this.partesDao.montarSelectTablaEjecFechaEj(idioma, filtro,
				UIDUsuario);
	}

	/**
	 * Obtiene el valor de una variable de la tabla VARIABLES_CORREO(AA2036T00)
	 * 
	 * @param variableCorreo
	 *            String
	 * @return String
	 */
	public String obtenerVariableCorreo(String variableCorreo) {
		return this.partesDao.obtenerVariableCorreo(variableCorreo);
	}

	/**
	 * Obtener parte pendiente de ejecución asociado a un tecnico y
	 * Edificio/Zona.
	 * 
	 * @param idEdificio
	 *            String
	 * @param idZona
	 *            Integer
	 * @param idTecnico
	 *            Long
	 * @return List
	 */
	public List<Partes> comprobarParteZonaTecnico(String idEdificio,
			Integer idZona, Long idTecnico) {
		return this.partesDao.comprobarParteZonaTecnico(idEdificio, idZona,
				idTecnico);
	}

	/**
	 * Eliminar parte
	 * 
	 * @param partes
	 *            Partes
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void eliminarParte(Partes partes) {
		Integer idParte = partes.getIdparte();

		// Actualizar IDPARTE=NULL en la tabla de Actuaciones para el parte dado
		actuacionDao.vaciarIdparte(idParte);

		// Eliminar plano asociado si existe en la tabla PARTEPLANOS
		Parteplano partePlano = new Parteplano();
		partePlano.setIdparte(idParte);
		parteplanoDao.remove(partePlano);

		// Eliminar Parte de la tabla PARTES
		this.partesDao.remove(partes);
	}

	public String enviarMailTecnico(Partes parteOrig, Tecnicos tecnicos)
			throws Exception {

		Partes parte = this.findParte(parteOrig);

		String to = "";

		// Acceder a los Diccionarios
		Locale loc = LocaleContextHolder.getLocale();
		Locale lCas = new Locale("ES");
		Locale lEus = new Locale("EU");

		try {
			// String remitente = this.appConfiguration.getObject().getProperty(
			// "user.mail.remitente");

			String variableRemitente = this
					.obtenerVariableCorreo("user.mail.remitente");

			if (variableRemitente == null || variableRemitente == "") {
				String retorno = this.appMessageSource.getMessage(
						"general.email.error", null, loc)
						+ "\n"
						+ this.appMessageSource.getMessage(
								"general.email.noExisteEmisor", null, loc);
				return retorno;
			} else {
				String host = this.appConfiguration.getObject().getProperty(
						"servidor.smtp");

				to = tecnicos.getMail();
				// to = "MJ-Mesanza@ejie.eus";

				String from = variableRemitente;

				Properties props = System.getProperties();
				props.put("mail.smtp.host", host);

				// Esta lÃ­nea indica que vamos a autenticarnos en el servidor
				// SMTP
				// props.put("mail.smtp.auth", "true");
				props.put("mail.smtp.auth", "false");

				// Obtener una sesiÃ³n con las propiedades anteriormente
				// definidas
				// Authenticator auth = new MiAutenticador();
				// Session sesion = Session.getDefaultInstance(props, auth);
				Session sesion = Session.getInstance(props);
				String urgenteCAS = "";
				String urgenteEUS = "";
				if (parte != null && parte.getUrgente() != null
						&& parte.getUrgente().equals("1")) {
					urgenteCAS = this.appMessageSource.getMessage(
							"parte.email.urgente", null, lEus);
					urgenteEUS = this.appMessageSource.getMessage(
							"parte.email.urgente", null, lCas);
				}

				String asunto = "##"
						+ urgenteCAS
						+ " "
						+ this.appMessageSource.getMessage(
								"parte.email.asunto", null, lEus)
						+ parte.getIdparte()
						+ " / "
						+ urgenteEUS
						+ " "
						+ this.appMessageSource.getMessage(
								"parte.email.asunto", null, lCas)
						+ +parte.getIdparte() + "##";

				/* EUSKERA */
				StringBuffer contenido = new StringBuffer("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.titulo", null, lEus)
						+ " "
						+ parte.getIdparte()
						+ " "
						+ this.appMessageSource.getMessage(
								"parte.email.titulo2", null, lEus) + "</p>");

				contenido.append("<p>");

				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.DatosPersonales", null, lEus)
						+ "</b>");
				contenido
						.append("<br/><b></u>"
								+ this.appMessageSource.getMessage(
										"parte.email.textoNombre", null, lEus)
								+ "</b>");
				contenido.append(" ").append(parte.getNombre());

				if (parte.getVip() != null && parte.getVip().equals("1")) {
					contenido.append("<br/><b><span style='color:red'>"
							+ this.appMessageSource.getMessage(
									"parte.email.vip", null, lEus)
							+ "</span></b>");
				}
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDepartamento", null, lEus)
						+ "</b>");
				contenido.append(" ").append(
						parte.getDepartamento().getEdepar());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDireccion", null, lEus)
						+ "</b>");
				contenido.append(" ").append(parte.getDireccion().getEdir());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.telefono", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getTelefo());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.email",
								null, lEus) + "</b>");
				contenido.append(" ").append(parte.getMail());
				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.LocAveria", null, lEus) + "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage(
								"parte.email.edificio", null, lEus) + "</b>");
				contenido.append(" ")
						.append(parte.getEdificio().getEedificio());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.planta", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getPlanta().getEplanta());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.zona",
								null, lEus) + "</b>");
				contenido.append(" ").append(parte.getZona().getEzona());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.espacio", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getEspacio().getEespacio());
				contenido.append("</p>");

				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.AveriaDetectada", null, lEus)
						+ "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage("parte.email.clase",
								null, lEus) + "</b>");
				contenido.append(" ").append(parte.getClase().getEclase());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.Activo", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getCodigo().getEcodigo());

				if (!"".equals(urgenteCAS)) {
					contenido
							.append("<br/><b>"
									+ this.appMessageSource.getMessage(
											"parte.email.urgente", null, lEus)
									+ "</b>");
				}

				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<br/><u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.descParte", null, lEus)
						+ "</b></u>");
				contenido.append(" ").append(parte.getObserv());
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.despedida", null, lEus) + "</p>");

				contenido.append("<br/>");
				contenido
						.append("<p style='font-style:italic;'>"
								+ this.appMessageSource.getMessage(
										"parte.email.norespuesta", null, lEus)
								+ "</p>");
				/**/

				contenido
						.append("___________________________________________________________________________________");

				/* CASTELLANO */
				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.titulo", null, lCas) + " "
						+ parte.getIdparte() + " " + parte.getIdparte()
						+ "</p>");

				contenido.append("<p>");

				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.DatosPersonales", null, lCas)
						+ "</b>");
				contenido
						.append("<br/><b></u>"
								+ this.appMessageSource.getMessage(
										"parte.email.textoNombre", null, lCas)
								+ "</b>");
				contenido.append(" ").append(parte.getNombre());

				if (parte.getVip() != null && parte.getVip().equals("1")) {
					contenido.append("<br/><b><span style='color:red'>"
							+ this.appMessageSource.getMessage(
									"parte.email.vip", null, lCas)
							+ "</span></b>");
				}
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDepartamento", null, lCas)
						+ "</b>");
				contenido.append(" ").append(
						parte.getDepartamento().getCdepar());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDireccion", null, lCas)
						+ "</b>");
				contenido.append(" ").append(parte.getDireccion().getCdir());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.telefono", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getTelefo());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.email",
								null, lCas) + "</b>");
				contenido.append(" ").append(parte.getMail());
				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.LocAveria", null, lCas) + "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage(
								"parte.email.edificio", null, lCas) + "</b>");
				contenido.append(" ")
						.append(parte.getEdificio().getCedificio());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.planta", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getPlanta().getCplanta());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.zona",
								null, lCas) + "</b>");
				contenido.append(" ").append(parte.getZona().getCzona());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.espacio", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getEspacio().getCespacio());
				contenido.append("</p>");

				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.AveriaDetectada", null, lCas)
						+ "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage("parte.email.clase",
								null, lCas) + "</b>");
				contenido.append(" ").append(parte.getClase().getCclase());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.Activo", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getCodigo().getCcodigo());

				if (!"".equals(urgenteCAS)) {
					contenido
							.append("<br/><b>"
									+ this.appMessageSource.getMessage(
											"parte.email.urgente", null, lCas)
									+ "</b>");
				}

				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<br/><u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.descParte", null, lCas)
						+ "</b></u>");
				contenido.append(" ").append(parte.getObserv());
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.despedida", null, lCas) + "</p>");

				contenido.append("<br/>");
				contenido
						.append("<p style='font-style:italic;'>"
								+ this.appMessageSource.getMessage(
										"parte.email.norespuesta", null, lCas)
								+ "</p>");
				/**/

				// contenido
				// .append("<img src='http://desarrollo.jakina.ejiedes.net:7001/aa20bMaqPartesWar/parteplano/mostrarPlanoParte?idParte="
				// + parte.getIdparte() + "'/>");
				/*
				 * String urlBase =
				 * this.appConfiguration.getObject().getProperty( "url_base");
				 * contenido .append("<img src='" + urlBase +
				 * "/aa20bMaqPartesWar/parteplano/mostrarPlanoParte?idParte=" +
				 * parte.getIdparte() + "'/>");
				 */
				// Añadir la imagen

				// Map<String, String> inlineImages = new HashMap<String,
				// String>();
				/*
				 * String urlBase =
				 * this.appConfiguration.getObject().getProperty( "url_base");
				 * inlineImages .put("planoAveria", urlBase +
				 * "/aa20bMaqPartesWar/parteplano/mostrarPlanoParte?idParte=" +
				 * parte.getIdparte());
				 */

				// Obtener el plano si tiene
				Parteplano planoParte = new Parteplano();
				planoParte.setIdparte(parte.getIdparte());

				planoParte = this.parteplanoService.find(planoParte);
				byte[] blobAsBytes = null;
				if (planoParte != null) {
					// Tiene plano
					int blobLeng = (int) planoParte.getDibujo().length();
					blobAsBytes = planoParte.getDibujo().getBytes(1, blobLeng);
				}

				// inlineImages.put("planoAveria", "D:/Koala.jpg");

				// FIN Añadir la imagen

				// create a message
				MimeMessage msg = new MimeMessage(sesion);
				msg.setFrom(new InternetAddress(from));
				msg.addRecipient(Message.RecipientType.TO, new InternetAddress(
						to));

				// String emailoculto = this.appConfiguration.getObject()
				// .getProperty("emailCopiaOculta");

				String variableEmailOculto = this
						.obtenerVariableCorreo("emailCopiaOculta");

				if (variableEmailOculto != null
						&& !variableEmailOculto.isEmpty())
					msg.addRecipient(Message.RecipientType.BCC,
							new InternetAddress(variableEmailOculto));
				// create and fill the first message part
				MimeBodyPart mbp1 = new MimeBodyPart();

				if (blobAsBytes != null) {
					contenido.append("<img src='cid:planoAveria\'/>");
				}
				// mbp1.setText(contenido.toString());
				mbp1.setContent(contenido.toString(), "text/html");
				// mbp1.setHeader("Content-Type",
				// "text/html; charset=ISO-8859-1");
				Multipart mp = new MimeMultipart();
				mp.addBodyPart(mbp1);

				if (blobAsBytes != null) {
					MimeBodyPart mbp2 = new MimeBodyPart();
					mbp2.setHeader("Content-ID", "<planoAveria>");
					mbp2.setDisposition(MimeBodyPart.INLINE);
					// create the Multipart and add its parts to it
					ByteArrayDataSource source = new ByteArrayDataSource(
							blobAsBytes, "image/jpeg");
					mbp2.setDataHandler(new DataHandler(source));
					mbp2.setFileName("planoParte.png");

					mp.addBodyPart(mbp2);
				}

				// Si hay imagen
				/*
				 * if (inlineImages != null && inlineImages.size() > 0) {
				 * Set<String> setImageID = inlineImages.keySet(); for (String
				 * contentId : setImageID) { MimeBodyPart imagePart = new
				 * MimeBodyPart(); ByteArrayDataSource source = new
				 * ByteArrayDataSource(blobAsBytes, "image/jpeg");
				 * 
				 * mbp1.setDataHandler(new DataHandler(source));
				 * mbp1.setFileName(attachment.getFileName());
				 * 
				 * 
				 * 
				 * String imageFilePath = inlineImages.get(contentId); try {
				 * imagePart.attachFile(imageFilePath); } catch (IOException ex)
				 * { ex.printStackTrace(); } mp.addBodyPart(imagePart); } }
				 */

				// add the Multipart to the message
				msg.setContent(mp);
				msg.setSubject(asunto);

				// set the Date: header
				msg.setSentDate(new Date());

				// send the message
				Transport.send(msg);

				planoParte = null;

				return "true";
			}
		} catch (Exception ex) {

			StackTraceElement[] trazas = ex.getStackTrace();
			for (StackTraceElement traza : trazas) {

			}
			StringBuffer retorno = new StringBuffer();
			retorno.append(
					this.appMessageSource.getMessage("general.email.error",
							null, loc))
					.append("\n")
					.append(this.appMessageSource.getMessage(
							"general.email.noExisteEmisor", null, loc));
			retorno.append(" ").append(to);
			return retorno.toString();
		}
	}

	public String enviarMailUsuResponsables(Partes parteOrig, String email)
			throws Exception {

		Partes parte = this.findParte(parteOrig);

		String to = "";

		// Acceder a los Diccionarios
		Locale loc = LocaleContextHolder.getLocale();
		Locale lCas = new Locale("ES");
		Locale lEus = new Locale("EU");

		try {

			String variableRemitente = this
					.obtenerVariableCorreo("user.mail.remitente");

			if (variableRemitente == null || variableRemitente == "") {
				String retorno = this.appMessageSource.getMessage(
						"general.email.error", null, loc)
						+ "\n"
						+ this.appMessageSource.getMessage(
								"general.email.noExisteEmisor", null, loc);
				return retorno;
			} else {
				String host = this.appConfiguration.getObject().getProperty(
						"servidor.smtp");

				to = email;

				String from = variableRemitente;

				Properties props = System.getProperties();
				props.put("mail.smtp.host", host);
				props.put("mail.smtp.auth", "false");

				Session sesion = Session.getInstance(props);

				String asunto = "## "
						+ parte.getIdparte()
						+ " "
						+ this.appMessageSource.getMessage(
								"parteresp.email.asuntourgente", null, lEus)
						+ " / "
						+ this.appMessageSource.getMessage(
								"parteresp.email.asunto1", null, lEus)
						+ " "
						+ parte.getIdparte()
						+ " "
						+ this.appMessageSource.getMessage(
								"parteresp.email.asunto2", null, lCas) + " "
						+ " ##";

				/* EUSKERA */
				StringBuffer contenido = new StringBuffer("<p>"
						+ this.appMessageSource.getMessage(
								"parteresp.email.titulo", null, lEus) + "</p>");

				contenido.append("<p>");

				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.DatosPersonales", null, lEus)
						+ "</b>");
				contenido
						.append("<br/><b></u>"
								+ this.appMessageSource.getMessage(
										"parte.email.textoNombre", null, lEus)
								+ "</b>");
				contenido.append(" ").append(parte.getNombre());

				if (parte.getVip() != null && parte.getVip().equals("1")) {
					contenido.append("<br/><b><span style='color:red'>"
							+ this.appMessageSource.getMessage(
									"parte.email.vip", null, lEus)
							+ "</span></b>");
				}
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDepartamento", null, lEus)
						+ "</b>");
				contenido.append(" ").append(
						parte.getDepartamento().getEdepar());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDireccion", null, lEus)
						+ "</b>");
				contenido.append(" ").append(parte.getDireccion().getEdir());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.telefono", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getTelefo());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.email",
								null, lEus) + "</b>");
				contenido.append(" ").append(parte.getMail());
				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.LocAveria", null, lEus) + "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage(
								"parte.email.edificio", null, lEus) + "</b>");
				contenido.append(" ")
						.append(parte.getEdificio().getEedificio());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.planta", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getPlanta().getEplanta());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.zona",
								null, lEus) + "</b>");
				contenido.append(" ").append(parte.getZona().getEzona());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.espacio", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getEspacio().getEespacio());
				contenido.append("</p>");

				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.AveriaDetectada", null, lEus)
						+ "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage("parte.email.clase",
								null, lEus) + "</b>");
				contenido.append(" ").append(parte.getClase().getEclase());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.Activo", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getCodigo().getEcodigo());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.urgente", null, lEus) + "</b>");

				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<br/><u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.descParte", null, lEus)
						+ "</b></u>");
				contenido.append(" ").append(parte.getObserv());
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.despedida", null, lEus) + "</p>");

				contenido.append("<br/>");
				contenido
						.append("<p style='font-style:italic;'>"
								+ this.appMessageSource.getMessage(
										"parte.email.norespuesta", null, lEus)
								+ "</p>");
				/**/

				contenido
						.append("___________________________________________________________________________________");

				/* CASTELLANO */
				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parteresp.email.titulo", null, lCas) + "</p>");

				contenido.append("<p>");

				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.DatosPersonales", null, lCas)
						+ "</b>");
				contenido
						.append("<br/><b></u>"
								+ this.appMessageSource.getMessage(
										"parte.email.textoNombre", null, lCas)
								+ "</b>");
				contenido.append(" ").append(parte.getNombre());

				if (parte.getVip() != null && parte.getVip().equals("1")) {
					contenido.append("<br/><b><span style='color:red'>"
							+ this.appMessageSource.getMessage(
									"parte.email.vip", null, lCas)
							+ "</span></b>");
				}
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDepartamento", null, lCas)
						+ "</b>");
				contenido.append(" ").append(
						parte.getDepartamento().getCdepar());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDireccion", null, lCas)
						+ "</b>");
				contenido.append(" ").append(parte.getDireccion().getCdir());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.telefono", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getTelefo());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.email",
								null, lCas) + "</b>");
				contenido.append(" ").append(parte.getMail());
				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.LocAveria", null, lCas) + "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage(
								"parte.email.edificio", null, lCas) + "</b>");
				contenido.append(" ")
						.append(parte.getEdificio().getCedificio());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.planta", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getPlanta().getCplanta());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.zona",
								null, lCas) + "</b>");
				contenido.append(" ").append(parte.getZona().getCzona());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.espacio", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getEspacio().getCespacio());
				contenido.append("</p>");

				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.AveriaDetectada", null, lCas)
						+ "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage("parte.email.clase",
								null, lCas) + "</b>");
				contenido.append(" ").append(parte.getClase().getCclase());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.Activo", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getCodigo().getCcodigo());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.urgente", null, lCas) + "</b>");

				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<br/><u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.descParte", null, lCas)
						+ "</b></u>");
				contenido.append(" ").append(parte.getObserv());
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.despedida", null, lCas) + "</p>");

				contenido.append("<br/>");
				contenido
						.append("<p style='font-style:italic;'>"
								+ this.appMessageSource.getMessage(
										"parte.email.norespuesta", null, lCas)
								+ "</p>");
				/**/

				// Obtener el plano si tiene
				Parteplano planoParte = new Parteplano();
				planoParte.setIdparte(parte.getIdparte());

				planoParte = this.parteplanoService.find(planoParte);
				byte[] blobAsBytes = null;
				if (planoParte != null) {
					// Tiene plano
					int blobLeng = (int) planoParte.getDibujo().length();
					blobAsBytes = planoParte.getDibujo().getBytes(1, blobLeng);
				}

				// FIN Añadir la imagen

				// create a message
				MimeMessage msg = new MimeMessage(sesion);
				msg.setFrom(new InternetAddress(from));
				msg.addRecipient(Message.RecipientType.TO, new InternetAddress(
						to));

				String variableEmailOculto = this
						.obtenerVariableCorreo("emailCopiaOculta");

				if (variableEmailOculto != null
						&& !variableEmailOculto.isEmpty())
					msg.addRecipient(Message.RecipientType.BCC,
							new InternetAddress(variableEmailOculto));
				// create and fill the first message part
				MimeBodyPart mbp1 = new MimeBodyPart();

				if (blobAsBytes != null) {
					contenido.append("<img src='cid:planoAveria\'/>");
				}

				mbp1.setContent(contenido.toString(), "text/html");

				Multipart mp = new MimeMultipart();
				mp.addBodyPart(mbp1);

				if (blobAsBytes != null) {
					MimeBodyPart mbp2 = new MimeBodyPart();
					mbp2.setHeader("Content-ID", "<planoAveria>");
					mbp2.setDisposition(MimeBodyPart.INLINE);
					// create the Multipart and add its parts to it
					ByteArrayDataSource source = new ByteArrayDataSource(
							blobAsBytes, "image/jpeg");
					mbp2.setDataHandler(new DataHandler(source));
					mbp2.setFileName("planoParte.png");

					mp.addBodyPart(mbp2);
				}

				// add the Multipart to the message
				msg.setContent(mp);
				msg.setSubject(asunto);

				// set the Date: header
				msg.setSentDate(new Date());

				// send the message
				Transport.send(msg);

				planoParte = null;

				return "true";
			}
		} catch (Exception ex) {

			StackTraceElement[] trazas = ex.getStackTrace();
			for (StackTraceElement traza : trazas) {

			}
			StringBuffer retorno = new StringBuffer();
			retorno.append(
					this.appMessageSource.getMessage("general.email.error",
							null, loc))
					.append("\n")
					.append(this.appMessageSource.getMessage(
							"general.email.noExisteEmisor", null, loc));
			retorno.append(" ").append(to);
			return retorno.toString();
		}
	}

}
