package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.ParteplanoDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Parteplano;

/**
 * ParteplanoServiceImpl generated by UDA, 13-ene-2015 13:00:39.
 * 
 * @author UDA
 */

@Service(value = "parteplanoService")
public class ParteplanoServiceImpl implements ParteplanoService {

	@Autowired
	private ParteplanoDao parteplanoDao;

	/**
	 * Inserts a single row in the Parteplano table.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @return Parteplano
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Parteplano add(Parteplano parteplano) {
		return this.parteplanoDao.add(parteplano);
	}

	/**
	 * Updates a single row in the Parteplano table.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @return Parteplano
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Parteplano update(Parteplano parteplano) {
		return this.parteplanoDao.update(parteplano);
	}

	/**
	 * Finds a single row in the Parteplano table.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @return Parteplano
	 */
	public Parteplano find(Parteplano parteplano) {
		return (Parteplano) this.parteplanoDao.find(parteplano);
	}

	/**
	 * Finds a List of rows in the Parteplano table.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Parteplano> findAll(Parteplano parteplano, Pagination pagination) {
		return (List<Parteplano>) this.parteplanoDao.findAll(parteplano,
				pagination);
	}

	/**
	 * Counts rows in the Parteplano table.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @return Long
	 */
	public Long findAllCount(Parteplano parteplano) {
		return this.parteplanoDao.findAllCount(parteplano);
	}

	/**
	 * Finds rows in the Parteplano table using like.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Parteplano> findAllLike(Parteplano parteplano,
			Pagination pagination, Boolean startsWith) {
		return (List<Parteplano>) this.parteplanoDao.findAllLike(parteplano,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Parteplano table using like.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Parteplano parteplano, Boolean startsWith) {
		return this.parteplanoDao.findAllLikeCount(parteplano, startsWith);
	}

	/**
	 * Deletes a single row in the Parteplano table.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Parteplano parteplano) {
		this.parteplanoDao.remove(parteplano);
	}

	/**
	 * Deletes multiple rows in the Parteplano table.
	 * 
	 * @param parteplanoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Parteplano> parteplanoList) {
		for (Parteplano parteplanoAux : parteplanoList) {
			this.parteplanoDao.remove(parteplanoAux);
		}
	}

	public byte[] buscaDibujo(Parteplano parteplano) {
		return this.parteplanoDao.buscaDibujo(parteplano);

	}

}
