package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.PartePdfDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Partepdf;

/**
 * PartepdfServiceImpl generated by UDA, 13-ene-2015 13:00:39.
 * 
 * @author UDA
 */

@Service(value = "partepdfService")
public class PartepdfServiceImpl implements PartepdfService {

	@Autowired
	private PartePdfDao partepdfDao;

	/**
	 * Inserts a single row in the Partepdf table.
	 * 
	 * @param partepdf
	 *            Partepdf
	 * @return Partepdf
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partepdf add(Partepdf partepdf) {
		return this.partepdfDao.add(partepdf);
	}

	/**
	 * Updates a single row in the Partepdf table.
	 * 
	 * @param partepdf
	 *            Partepdf
	 * @return Partepdf
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partepdf update(Partepdf partepdf) {
		return this.partepdfDao.update(partepdf);
	}

	/**
	 * Finds a single row in the Partepdf table.
	 * 
	 * @param partepdf
	 *            Partepdf
	 * @return Partepdf
	 */
	public Partepdf find(Partepdf partepdf) {
		return (Partepdf) this.partepdfDao.find(partepdf);
	}

	/**
	 * Finds a List of rows in the Partepdf table.
	 * 
	 * @param partepdf
	 *            Partepdf
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Partepdf> findAll(Partepdf partepdf, Pagination pagination) {
		return (List<Partepdf>) this.partepdfDao.findAll(partepdf, pagination);
	}

	/**
	 * Counts rows in the Partepdf table.
	 * 
	 * @param partepdf
	 *            Partepdf
	 * @return Long
	 */
	public Long findAllCount(Partepdf partepdf) {
		return this.partepdfDao.findAllCount(partepdf);
	}

	/**
	 * Finds rows in the Partepdf table using like.
	 * 
	 * @param partepdf
	 *            Partepdf
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Partepdf> findAllLike(Partepdf partepdf, Pagination pagination,
			Boolean startsWith) {
		return (List<Partepdf>) this.partepdfDao.findAllLike(partepdf,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Partepdf table using like.
	 * 
	 * @param partepdf
	 *            Partepdf
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Partepdf partepdf, Boolean startsWith) {
		return this.partepdfDao.findAllLikeCount(partepdf, startsWith);
	}

	/**
	 * Deletes a single row in the Partepdf table.
	 * 
	 * @param partepdf
	 *            Partepdf
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Partepdf partepdf) {
		this.partepdfDao.remove(partepdf);
	}

	/**
	 * Deletes multiple rows in the Partepdf table.
	 * 
	 * @param partepdfList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Partepdf> partepdfList) {
		for (Partepdf partepdfAux : partepdfList) {
			this.partepdfDao.remove(partepdfAux);
		}
	}

	public byte[] buscaPdf(Partepdf partepdf) {
		return this.partepdfDao.buscaPdf(partepdf);

	}

}
