package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.PartefirmaDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Partefirma;

/**
 * PartefirmaServiceImpl generated by UDA, 13-ene-2015 13:00:39.
 * 
 * @author UDA
 */

@Service(value = "partefirmaService")
public class PartefirmaServiceImpl implements PartefirmaService {

	@Autowired
	private PartefirmaDao partefirmaDao;

	/**
	 * Inserts a single row in the Partefirma table.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @return Partefirma
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partefirma add(Partefirma partefirma) {
		return this.partefirmaDao.add(partefirma);
	}

	/**
	 * Updates a single row in the Partefirma table.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @return Partefirma
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Partefirma update(Partefirma partefirma) {
		return this.partefirmaDao.update(partefirma);
	}

	/**
	 * Finds a single row in the Partefirma table.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @return Partefirma
	 */
	public Partefirma find(Partefirma partefirma) {
		return (Partefirma) this.partefirmaDao.find(partefirma);
	}

	/**
	 * Finds a List of rows in the Partefirma table.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Partefirma> findAll(Partefirma partefirma, Pagination pagination) {
		return (List<Partefirma>) this.partefirmaDao.findAll(partefirma,
				pagination);
	}

	/**
	 * Counts rows in the Partefirma table.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @return Long
	 */
	public Long findAllCount(Partefirma partefirma) {
		return this.partefirmaDao.findAllCount(partefirma);
	}

	/**
	 * Finds rows in the Partefirma table using like.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Partefirma> findAllLike(Partefirma partefirma,
			Pagination pagination, Boolean startsWith) {
		return (List<Partefirma>) this.partefirmaDao.findAllLike(partefirma,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Partefirma table using like.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Partefirma partefirma, Boolean startsWith) {
		return this.partefirmaDao.findAllLikeCount(partefirma, startsWith);
	}

	/**
	 * Deletes a single row in the Partefirma table.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Partefirma partefirma) {
		this.partefirmaDao.remove(partefirma);
	}

	/**
	 * Deletes multiple rows in the Partefirma table.
	 * 
	 * @param partefirmaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Partefirma> partefirmaList) {
		for (Partefirma partefirmaAux : partefirmaList) {
			this.partefirmaDao.remove(partefirmaAux);
		}
	}

	public byte[] buscaFirma(Partefirma partefirma) {
		return this.partefirmaDao.buscaFirma(partefirma);

	}

}
