package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Partefirma;

/**
 * PartefirmaService generated by UDA, 13-ene-2015 13:00:39.
 * 
 * @author UDA
 */

public interface PartefirmaService {

	/**
	 * Inserts a single row in the Partefirma table.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @return Partefirma
	 */
	Partefirma add(Partefirma partefirma);

	/**
	 * Updates a single row in the Partefirma table.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @return Partefirma
	 */
	Partefirma update(Partefirma partefirma);

	/**
	 * Finds a single row in the Partefirma table.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @return Partefirma
	 */
	Partefirma find(Partefirma partefirma);

	/**
	 * Finds a List of rows in the Partefirma table.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Partefirma> findAll(Partefirma partefirma, Pagination pagination);

	/**
	 * Counts rows in the Partefirma table.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @return Long
	 */
	Long findAllCount(Partefirma partefirma);

	/**
	 * Finds rows in the Partefirma table using like.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Partefirma> findAllLike(Partefirma partefirma, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Partefirma table using like.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Partefirma partefirma, Boolean startsWith);

	/**
	 * Deletes a single row in the Partefirma table.
	 * 
	 * @param partefirma
	 *            Partefirma
	 * @return
	 */
	void remove(Partefirma partefirma);

	/**
	 * Deletes multiple rows in the Partefirma table.
	 * 
	 * @param partefirmaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Partefirma> partefirmaList);

	byte[] buscaFirma(Partefirma partefirma);

}
