package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.ParteejecucionDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Parteejecucion;

/**
 * ParteejecucionServiceImpl generated by UDA, 22-ene-2015 12:41:36.
 * 
 * @author UDA
 */

@Service(value = "parteejecucionService")
public class ParteejecucionServiceImpl implements ParteejecucionService {

	@Autowired
	private ParteejecucionDao parteejecucionDao;

	/**
	 * Inserts a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Parteejecucion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Parteejecucion add(Parteejecucion parteejecucion) {
		return this.parteejecucionDao.add(parteejecucion);
	}

	/**
	 * Inserts a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Parteejecucion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Parteejecucion nuevaEjecucionParte(Parteejecucion parteejecucion) {
		// Se comprobara que las fechas/horas introducidas no son incongruentes
		// con otras ejecuciones de ese tecnico y parte
		// la fecha de inicio no puede estar entre la fecha inicio y fecha fin
		// de otra ejecucion
		// la fecha de fin no puede estar entre la fecha inicio y fecha fin de
		// otra ejecucion
		Parteejecucion parteEncontrado = new Parteejecucion();

		parteEncontrado = this.parteejecucionDao
				.fechasEjecCorrectas(parteejecucion);
		// parteEncontrado =
		if (parteEncontrado != null) {
			// Ha encontrado al menos un registro
			return null;
		} else {
			// Está correcto. Damos de alta la nueva ejecucion
			return this.parteejecucionDao.add(parteejecucion);
		}

	}

	/**
	 * Inserts a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Parteejecucion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Parteejecucion modificarEjecucionParte(Parteejecucion parteejecucion) {
		// Se comprobara que las fechas/horas introducidas no son incongruentes
		// con otras ejecuciones de ese tecnico y parte
		// la fecha de inicio no puede estar entre la fecha inicio y fecha fin
		// de otra ejecucion
		// la fecha de fin no puede estar entre la fecha inicio y fecha fin de
		// otra ejecucion
		// No puede haber otra ejecución en medio de las fechas/horas de inicio
		// y fin de la nueva ejecución
		Parteejecucion parteEncontrado = new Parteejecucion();

		parteEncontrado = this.parteejecucionDao
				.fechasEjecCorrectas(parteejecucion);
		// parteEncontrado =
		if (parteEncontrado != null) {
			// Ha encontrado al menos un registro
			return null;
		} else {
			// Está correcto. Damos de alta la nueva ejecucion
			return this.parteejecucionDao.modificarFechasEjec(parteejecucion);
		}

	}

	/**
	 * Updates a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Parteejecucion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Parteejecucion update(Parteejecucion parteejecucion) {
		return this.parteejecucionDao.update(parteejecucion);
	}

	/**
	 * Finds a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Parteejecucion
	 */
	public Parteejecucion find(Parteejecucion parteejecucion) {
		return (Parteejecucion) this.parteejecucionDao.find(parteejecucion);
	}

	/**
	 * Finds a List of rows in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Parteejecucion> findAll(Parteejecucion parteejecucion,
			Pagination pagination) {
		return (List<Parteejecucion>) this.parteejecucionDao.findAll(
				parteejecucion, pagination);
	}

	/**
	 * Counts rows in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Long
	 */
	public Long findAllCount(Parteejecucion parteejecucion) {
		return this.parteejecucionDao.findAllCount(parteejecucion);
	}

	/**
	 * Finds rows in the Parteejecucion table using like.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Parteejecucion> findAllLike(Parteejecucion parteejecucion,
			Pagination pagination, Boolean startsWith) {
		return (List<Parteejecucion>) this.parteejecucionDao.findAllLike(
				parteejecucion, pagination, startsWith);
	}

	/**
	 * Counts rows in the Parteejecucion table using like.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Parteejecucion parteejecucion,
			Boolean startsWith) {
		return this.parteejecucionDao.findAllLikeCount(parteejecucion,
				startsWith);
	}

	/**
	 * Deletes a single row in the Parteejecucion table.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Parteejecucion parteejecucion) {
		this.parteejecucionDao.remove(parteejecucion);
	}

	/**
	 * Deletes multiple rows in the Parteejecucion table.
	 * 
	 * @param parteejecucionList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Parteejecucion> parteejecucionList) {
		for (Parteejecucion parteejecucionAux : parteejecucionList) {
			this.parteejecucionDao.remove(parteejecucionAux);
		}
	}

	/**
	 * Calcula el tiempo total de ejecucion de un parte tecnico.y actualiza el
	 * campo TIEMPOREAL de la tabla PARTETECNICOS
	 * 
	 * @param idParteTec
	 *            Integer
	 * @return Integer
	 */
	public Boolean recalcularTiempoParteTecnico(Integer idParteTec) {
		return this.parteejecucionDao.recalcularTiempoParteTecnico(idParteTec);
	}

}
