package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;

import java.util.ArrayList;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.ActAnual;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.PlanGeneral;
import com.ejie.aa20b.model.PrevAnual;

/**
 * MaquinasService generated by UDA, 04-mar-2015 15:44:06.
 * 
 * @author UDA
 */

public interface MaquinasService {

	/**
	 * Inserts a single row in the Maquinas table.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @return Maquinas
	 */
	Maquinas add(Maquinas maquinas);

	/**
	 * Updates a single row in the Maquinas table.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @return Maquinas
	 */
	Maquinas update(Maquinas maquinas);

	/**
	 * Finds a single row in the Maquinas table.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @return Maquinas
	 */
	Maquinas find(Maquinas maquinas);

	/**
	 * Finds a List of rows in the Maquinas table.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Maquinas> findAll(Maquinas maquinas, Pagination pagination);

	/**
	 * Counts rows in the Maquinas table.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @return Long
	 */
	Long findAllCount(Maquinas maquinas);

	/**
	 * Finds rows in the Maquinas table using like.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Maquinas> findAllLike(Maquinas maquinas, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Maquinas table using like.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Maquinas maquinas, Boolean startsWith);

	/**
	 * Deletes a single row in the Maquinas table.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @return
	 */
	void remove(Maquinas maquinas);

	/**
	 * Deletes multiple rows in the Maquinas table.
	 * 
	 * @param maquinasList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Maquinas> maquinasList);

	/**
	 * Obtiene las máquinas de edificios relacionados con el usuario de XLNET.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Maquinas> obtenerMaquinasUsuario(Maquinas maquinas,
			Pagination pagination, Boolean startsWith, String sUIDUsuario);

	/**
	 * Counts máquinas de edificios relacionados con el usuario de XLNET.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long obtenerMaquinasUsuarioCount(Maquinas maquinas, Boolean startsWith,
			String sUIDUsuario);

	/**
	 * Finds a single row in the Maquinas table.
	 * 
	 * @param idMaquina
	 *            String
	 * @return Maquinas
	 */
	Maquinas obtenerMaquina(String idMaquina);

	@SuppressWarnings("rawtypes")
	public ArrayList obtenerPlanificiacionGeneral(PlanGeneral filtroPlanGeneral);

	@SuppressWarnings("rawtypes")
	public ArrayList obtenerPlanificiacionGeneral(
			PlanGeneral filtroPlanGeneral, Pagination pagination);

	/**
	 * obtener los ID máquinas que cumplen con el filtro
	 * 
	 * @param filtroPlanGeneral
	 *            PlanGeneral
	 * @param Pagination
	 *            pagination
	 * @return ArrayList
	 */
	public ArrayList obtenerIdMaquinasPG(PlanGeneral filtroPlanGeneral,
			Pagination pagination);

	/**
	 * obtener los ID máquinas que cumplen con el filtro
	 * 
	 * @param filtroPrevAnual
	 *            PrevAnual
	 * @param Pagination
	 *            pagination
	 * @return ArrayList
	 */
	public ArrayList obtenerIdMaquinasPA(PrevAnual filtroPrevAnual,
			Pagination pagination);

	/**
	 * obtener los ID máquinas que cumplen con el filtro
	 * 
	 * @param filtroActAnual
	 *            ActAnual
	 * @param Pagination
	 *            pagination
	 * @return ArrayList
	 */
	public ArrayList obtenerIdMaquinasAA(ActAnual filtroActAnual,
			Pagination pagination);

	Long obtenerPlanificiacionGeneralCount(PlanGeneral filtroPlanGeneral);

	/**
	 * obtener el número de máquinas que cumplen con el filtro
	 * 
	 * @param filtroPlanGeneral
	 *            PlanGeneral
	 * @return Long
	 */
	Long obtenerMaquinasPGCount(PlanGeneral filtroPlanGeneral);

	/**
	 * obtener el número de máquinas que cumplen con el filtro
	 * 
	 * @param filtroPrevAnual
	 *            PrevAnual
	 * @return Long
	 */
	Long obtenerMaquinasPACount(PrevAnual filtroPrevAnual);

	/**
	 * obtener el número de máquinas que cumplen con el filtro
	 * 
	 * @param filtroActAnual
	 *            ActAnual
	 * @return Long
	 */
	Long obtenerMaquinasAACount(ActAnual filtroActAnual);

	/**
	 * obtener los datos de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroPlanGeneral
	 *            PlanGeneral
	 * @param idMaquinas
	 *            String
	 * @return ArrayList
	 */
	@SuppressWarnings("rawtypes")
	ArrayList obtenerPG(PlanGeneral filtroPlanGeneral, String idMaquinas);

	/**
	 * obtener los datos de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroPlanGeneral
	 *            PlanGeneral
	 * @return ArrayList
	 */
	@SuppressWarnings("rawtypes")
	ArrayList obtenerPGImprimir(PlanGeneral filtroPlanGeneral);

	/**
	 * obtener los datos de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroPrevAnual
	 *            PrevAnual
	 * @param idMaquinas
	 *            String
	 * @return ArrayList
	 */
	@SuppressWarnings("rawtypes")
	ArrayList obtenerPA(PrevAnual filtroPrevAnual, String idMaquinas);

	/**
	 * obtener los datos de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroActAnual
	 *            ActAnual
	 * @param idMaquinas
	 *            String
	 * @return ArrayList
	 */
	@SuppressWarnings("rawtypes")
	ArrayList obtenerAA(ActAnual filtroActAnual, String idMaquinas);

	/**
	 * obtener los datos de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroActAnual
	 *            ActAnual
	 * @param idMaquinas
	 *            String
	 * @return ArrayList
	 */
	@SuppressWarnings("rawtypes")
	ArrayList obtenerAARealEdif(ActAnual filtroActAnual, String idMaquinas);

	/**
	 * obtener los datos de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroPrevAnual
	 *            PrevAnual
	 * @return ArrayList
	 */
	@SuppressWarnings("rawtypes")
	ArrayList obtenerPAImprimir(PrevAnual filtroPrevAnual);

	/**
	 * obtener los cuestionarios de las máquinas que cumplen con el filtro
	 * 
	 * @param filtroPrevAnual
	 *            PrevAnual
	 * @param idMaquinas
	 *            String
	 * @return List<Maquinas>
	 */
	@SuppressWarnings("rawtypes")
	List<Maquinas> obtenerCuestionariosMaquinas(PrevAnual filtroPrevAnual,
			String idMaquinas);

	/**
	 * Crear Parte Automático.
	 * 
	 * @param idMaquina
	 *            Integer
	 * @param sUIDUsuario
	 *            String
	 * @return String
	 */
	public Ficha crearParteAutomatico(Long idMaquina, String sUIDUsuario,
			String mantenerTecnicos);

	/**
	 * Actualiza la fechas de primer y siguiente mantenimiento para una máquina.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @return Maquinas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Maquinas actualizarFechasMto(Maquinas maquinas);

}
