package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.GamasDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Gamas;

/**
 * GamasServiceImpl generated by UDA, 02-mar-2015 11:32:36.
 * 
 * @author UDA
 */

@Service(value = "gamasService")
public class GamasServiceImpl implements GamasService {

	@Autowired
	private GamasDao gamasDao;

	/**
	 * Inserts a single row in the Gamas table.
	 * 
	 * @param gamas
	 *            Gamas
	 * @return Gamas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Gamas add(Gamas gamas) {
		return this.gamasDao.add(gamas);
	}

	/**
	 * Updates a single row in the Gamas table.
	 * 
	 * @param gamas
	 *            Gamas
	 * @return Gamas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Gamas update(Gamas gamas) {
		return this.gamasDao.update(gamas);
	}

	/**
	 * Finds a single row in the Gamas table.
	 * 
	 * @param gamas
	 *            Gamas
	 * @return Gamas
	 */
	public Gamas find(Gamas gamas) {
		return (Gamas) this.gamasDao.find(gamas);
	}

	/**
	 * Finds a List of rows in the Gamas table.
	 * 
	 * @param gamas
	 *            Gamas
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Gamas> findAll(Gamas gamas, Pagination pagination) {
		return (List<Gamas>) this.gamasDao.findAll(gamas, pagination);
	}

	public List<Clase> findClasesGamaServicio(Gamas gamas, Pagination pagination) {
		return (List<Clase>) this.gamasDao.findClasesGamaServicio(gamas,
				pagination);
	}

	/**
	 * Counts rows in the Gamas table.
	 * 
	 * @param gamas
	 *            Gamas
	 * @return Long
	 */
	public Long findAllCount(Gamas gamas) {
		return this.gamasDao.findAllCount(gamas);
	}

	/**
	 * Finds rows in the Gamas table using like.
	 * 
	 * @param gamas
	 *            Gamas
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Gamas> findAllLike(Gamas gamas, Pagination pagination,
			Boolean startsWith) {
		return (List<Gamas>) this.gamasDao.findAllLike(gamas, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Gamas table using like.
	 * 
	 * @param gamas
	 *            Gamas
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Gamas gamas, Boolean startsWith) {
		return this.gamasDao.findAllLikeCount(gamas, startsWith);
	}

	/**
	 * Deletes a single row in the Gamas table.
	 * 
	 * @param gamas
	 *            Gamas
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Gamas gamas) {
		this.gamasDao.remove(gamas);
	}

	/**
	 * Deletes multiple rows in the Gamas table.
	 * 
	 * @param gamasList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Gamas> gamasList) {
		for (Gamas gamasAux : gamasList) {
			this.gamasDao.remove(gamasAux);
		}
	}

	/**
	 * Finds a single row in the Gamas table.
	 * 
	 * @param idGama
	 *            String
	 * @return Gamas
	 */
	public Gamas obtenerGama(String idGama) {
		return (Gamas) this.gamasDao.obtenerGama(idGama);
	}
}
