package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.FichatecnicoDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Fichatecnico;

/**
 * FichatecnicoServiceImpl generated by UDA, 07-abr-2015 11:48:09.
 * 
 * @author UDA
 */

@Service(value = "fichatecnicoService")
public class FichatecnicoServiceImpl implements FichatecnicoService {

	@Autowired
	private FichatecnicoDao fichatecnicoDao;

	/**
	 * Inserts a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Fichatecnico add(Fichatecnico fichatecnico) {
		return this.fichatecnicoDao.add(fichatecnico);
	}

	/**
	 * Updates a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Fichatecnico update(Fichatecnico fichatecnico) {
		return this.fichatecnicoDao.update(fichatecnico);
	}

	/**
	 * Finds a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	public Fichatecnico find(Fichatecnico fichatecnico) {
		return (Fichatecnico) this.fichatecnicoDao.find(fichatecnico);
	}

	public Fichatecnico obtenerFicha(Integer idFitec) {
		return (Fichatecnico) this.fichatecnicoDao.obtenerFicha(idFitec);
	}

	/**
	 * Finds a List of rows in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Fichatecnico> findAll(Fichatecnico fichatecnico,
			Pagination pagination) {
		return (List<Fichatecnico>) this.fichatecnicoDao.findAll(fichatecnico,
				pagination);
	}

	/**
	 * Counts rows in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Long
	 */
	public Long findAllCount(Fichatecnico fichatecnico) {
		return this.fichatecnicoDao.findAllCount(fichatecnico);
	}

	/**
	 * Finds rows in the Fichatecnico table using like.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Fichatecnico> findAllLike(Fichatecnico fichatecnico,
			Pagination pagination, Boolean startsWith) {
		return (List<Fichatecnico>) this.fichatecnicoDao.findAllLike(
				fichatecnico, pagination, startsWith);
	}

	/**
	 * Counts rows in the Fichatecnico table using like.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Fichatecnico fichatecnico, Boolean startsWith) {
		return this.fichatecnicoDao.findAllLikeCount(fichatecnico, startsWith);
	}

	/**
	 * Deletes a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Fichatecnico fichatecnico) {
		this.fichatecnicoDao.remove(fichatecnico);
	}

	/**
	 * Deletes multiple rows in the Fichatecnico table.
	 * 
	 * @param fichatecnicoList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Fichatecnico> fichatecnicoList) {
		for (Fichatecnico fichatecnicoAux : fichatecnicoList) {
			this.fichatecnicoDao.remove(fichatecnicoAux);
		}
	}

	/**
	 * Finds a List of rows in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Fichatecnico> tecnicosFichaGrid(Fichatecnico fichatecnico,
			Pagination pagination) {
		return (List<Fichatecnico>) this.fichatecnicoDao.tecnicosFichaGrid(
				fichatecnico, pagination);
	}

	/**
	 * Counts rows in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Long
	 */
	public Long tecnicosFichaGridCount(Fichatecnico fichatecnico) {
		return this.fichatecnicoDao.tecnicosFichaGridCount(fichatecnico);
	}

	/**
	 * Obtener tecnicos asociados a una ficha.
	 * 
	 * @param idFicha
	 *            Integer
	 * @return List
	 */
	public List<Fichatecnico> obtenerTecnicosFichaAsociados(Integer idFicha) {
		return (List<Fichatecnico>) this.fichatecnicoDao
				.obtenerTecnicosFichaAsociados(idFicha);
	}

	/**
	 * Eliminar un tecnico asociado a una ficha.
	 * 
	 * @param fichatecnicos
	 *            Fichatecnico
	 * @return
	 */
	public void eliminaTecnicoFicha(Fichatecnico fichatecnicos) {
		this.fichatecnicoDao.eliminaTecnicoFicha(fichatecnicos);
	}

	/**
	 * Updates a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Fichatecnico guardarNotas(Fichatecnico fichatecnico) {
		return this.fichatecnicoDao.guardarNotas(fichatecnico);
	}

	@Transactional(rollbackFor = Throwable.class)
	public Fichatecnico guardarNotasTecnico(Fichatecnico fichatecnico) {
		return this.fichatecnicoDao.guardarNotasTecnico(fichatecnico);
	}

	/**
	 * Finalizar/Abrir ficha tecnico.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Fichatecnico finalizarFichaTec(Fichatecnico fichatecnico) {
		return this.fichatecnicoDao.finalizarFichaTec(fichatecnico);
	}

	/**
	 * marcar enviomail a single row in the Fichatecnico table.
	 * 
	 * @param idFicha
	 *            Integer
	 * @param idTecnico
	 *            Long
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void marcarEnvioMail(Integer idFicha, Long idTecnico) {
		this.fichatecnicoDao.marcarEnvioMail(idFicha, idTecnico);
	}
}
