package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Fichatecnico;

/**
 * FichatecnicoService generated by UDA, 07-abr-2015 11:48:09.
 * 
 * @author UDA
 */

public interface FichatecnicoService {

	/**
	 * Inserts a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	Fichatecnico add(Fichatecnico fichatecnico);

	/**
	 * Updates a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	Fichatecnico update(Fichatecnico fichatecnico);

	/**
	 * Finds a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	Fichatecnico find(Fichatecnico fichatecnico);

	Fichatecnico obtenerFicha(Integer idFitec);

	/**
	 * Finds a List of rows in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Fichatecnico> findAll(Fichatecnico fichatecnico, Pagination pagination);

	/**
	 * Counts rows in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Long
	 */
	Long findAllCount(Fichatecnico fichatecnico);

	/**
	 * Finds rows in the Fichatecnico table using like.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Fichatecnico> findAllLike(Fichatecnico fichatecnico,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Fichatecnico table using like.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Fichatecnico fichatecnico, Boolean startsWith);

	/**
	 * Deletes a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return
	 */
	void remove(Fichatecnico fichatecnico);

	/**
	 * Deletes multiple rows in the Fichatecnico table.
	 * 
	 * @param fichatecnicoList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Fichatecnico> fichatecnicoList);

	/**
	 * Finds a List of rows in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Fichatecnico> tecnicosFichaGrid(Fichatecnico fichatecnico,
			Pagination pagination);

	/**
	 * Counts rows in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Long
	 */
	Long tecnicosFichaGridCount(Fichatecnico fichatecnico);

	/**
	 * Obtener tecnicos asociados a una ficha.
	 * 
	 * @param idFicha
	 *            Integer
	 * @return List
	 */
	List<Fichatecnico> obtenerTecnicosFichaAsociados(Integer idFicha);

	/**
	 * Eliminar un tecnico asociado a una ficha.
	 * 
	 * @param fichatecnicos
	 *            Fichatecnico
	 * @return
	 */
	public void eliminaTecnicoFicha(Fichatecnico fichatecnicos);

	/**
	 * Updates a single row in the Fichatecnico table.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	Fichatecnico guardarNotas(Fichatecnico fichatecnico);

	Fichatecnico guardarNotasTecnico(Fichatecnico fichatecnico);

	/**
	 * Finalizar/abrir ficha tecnico.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	Fichatecnico finalizarFichaTec(Fichatecnico fichatecnico);

	/**
	 * marcar enviomail a single row in the Fichatecnico table.
	 * 
	 * @param idFicha
	 *            Integer
	 * @param idTecnico
	 *            Long
	 * @return
	 */
	public void marcarEnvioMail(Integer idFicha, Long idTecnico);
}
