package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.FichafirmaDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Fichafirma;

/**
 * FichafirmaServiceImpl generated by UDA, 13-ene-2015 13:00:39.
 * 
 * @author UDA
 */

@Service(value = "fichafirmaService")
public class FichafirmaServiceImpl implements FichafirmaService {

	@Autowired
	private FichafirmaDao fichafirmaDao;

	/**
	 * Inserts a single row in the Fichafirma table.
	 * 
	 * @param fichafirma
	 *            Fichafirma
	 * @return Fichafirma
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Fichafirma add(Fichafirma fichafirma) {
		return this.fichafirmaDao.add(fichafirma);
	}

	/**
	 * Updates a single row in the Fichafirma table.
	 * 
	 * @param fichafirma
	 *            Fichafirma
	 * @return Fichafirma
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Fichafirma update(Fichafirma fichafirma) {
		return this.fichafirmaDao.update(fichafirma);
	}

	/**
	 * Finds a single row in the Fichafirma table.
	 * 
	 * @param fichafirma
	 *            Fichafirma
	 * @return Fichafirma
	 */
	public Fichafirma find(Fichafirma fichafirma) {
		return (Fichafirma) this.fichafirmaDao.find(fichafirma);
	}

	/**
	 * Finds a List of rows in the Fichafirma table.
	 * 
	 * @param fichafirma
	 *            Fichafirma
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Fichafirma> findAll(Fichafirma fichafirma, Pagination pagination) {
		return (List<Fichafirma>) this.fichafirmaDao.findAll(fichafirma,
				pagination);
	}

	/**
	 * Counts rows in the Fichafirma table.
	 * 
	 * @param fichafirma
	 *            Fichafirma
	 * @return Long
	 */
	public Long findAllCount(Fichafirma fichafirma) {
		return this.fichafirmaDao.findAllCount(fichafirma);
	}

	/**
	 * Finds rows in the Fichafirma table using like.
	 * 
	 * @param fichafirma
	 *            Fichafirma
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Fichafirma> findAllLike(Fichafirma fichafirma,
			Pagination pagination, Boolean startsWith) {
		return (List<Fichafirma>) this.fichafirmaDao.findAllLike(fichafirma,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Fichafirma table using like.
	 * 
	 * @param fichafirma
	 *            Fichafirma
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Fichafirma fichafirma, Boolean startsWith) {
		return this.fichafirmaDao.findAllLikeCount(fichafirma, startsWith);
	}

	/**
	 * Deletes a single row in the Fichafirma table.
	 * 
	 * @param fichafirma
	 *            Fichafirma
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Fichafirma fichafirma) {
		this.fichafirmaDao.remove(fichafirma);
	}

	/**
	 * Deletes multiple rows in the Fichafirma table.
	 * 
	 * @param fichafirmaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Fichafirma> fichafirmaList) {
		for (Fichafirma fichafirmaAux : fichafirmaList) {
			this.fichafirmaDao.remove(fichafirmaAux);
		}
	}

	public byte[] buscaFirma(Fichafirma fichafirma) {
		return this.fichafirmaDao.buscaFirma(fichafirma);

	}

}
