package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Fichafirma;

/**
 * FichafirmaService generated by UDA, 13-ene-2015 13:00:39.
 * 
 * @author UDA
 */

public interface FichafirmaService {

	/**
	 * Inserts a single row in the Fichafirma table.
	 * 
	 * @param partefirma
	 *            Fichafirma
	 * @return Fichafirma
	 */
	Fichafirma add(Fichafirma partefirma);

	/**
	 * Updates a single row in the Fichafirma table.
	 * 
	 * @param partefirma
	 *            Fichafirma
	 * @return Fichafirma
	 */
	Fichafirma update(Fichafirma partefirma);

	/**
	 * Finds a single row in the Fichafirma table.
	 * 
	 * @param partefirma
	 *            Fichafirma
	 * @return Fichafirma
	 */
	Fichafirma find(Fichafirma partefirma);

	/**
	 * Finds a List of rows in the Fichafirma table.
	 * 
	 * @param partefirma
	 *            Fichafirma
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Fichafirma> findAll(Fichafirma partefirma, Pagination pagination);

	/**
	 * Counts rows in the Fichafirma table.
	 * 
	 * @param partefirma
	 *            Fichafirma
	 * @return Long
	 */
	Long findAllCount(Fichafirma partefirma);

	/**
	 * Finds rows in the Fichafirma table using like.
	 * 
	 * @param partefirma
	 *            Fichafirma
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Fichafirma> findAllLike(Fichafirma partefirma, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Fichafirma table using like.
	 * 
	 * @param partefirma
	 *            Fichafirma
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Fichafirma partefirma, Boolean startsWith);

	/**
	 * Deletes a single row in the Fichafirma table.
	 * 
	 * @param partefirma
	 *            Fichafirma
	 * @return
	 */
	void remove(Fichafirma partefirma);

	/**
	 * Deletes multiple rows in the Fichafirma table.
	 * 
	 * @param partefirmaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Fichafirma> partefirmaList);

	byte[] buscaFirma(Fichafirma partefirma);

}
