package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.FichaejecucionDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Fichaejecucion;

/**
 * FichaejecucionServiceImpl generated by UDA, 13-may-2015 16:26:16.
 * 
 * @author UDA
 */

@Service(value = "fichaejecucionService")
public class FichaejecucionServiceImpl implements FichaejecucionService {

	@Autowired
	private FichaejecucionDao fichaejecucionDao;

	/**
	 * Inserts a single row in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @return Fichaejecucion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Fichaejecucion add(Fichaejecucion fichaejecucion) {
		return this.fichaejecucionDao.add(fichaejecucion);
	}

	/**
	 * Updates a single row in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @return Fichaejecucion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Fichaejecucion update(Fichaejecucion fichaejecucion) {
		return this.fichaejecucionDao.update(fichaejecucion);
	}

	/**
	 * Finds a single row in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @return Fichaejecucion
	 */
	public Fichaejecucion find(Fichaejecucion fichaejecucion) {
		return (Fichaejecucion) this.fichaejecucionDao.find(fichaejecucion);
	}

	/**
	 * Finds a List of rows in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Fichaejecucion> findAll(Fichaejecucion fichaejecucion,
			Pagination pagination) {
		return (List<Fichaejecucion>) this.fichaejecucionDao.findAll(
				fichaejecucion, pagination);
	}

	/**
	 * Counts rows in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @return Long
	 */
	public Long findAllCount(Fichaejecucion fichaejecucion) {
		return this.fichaejecucionDao.findAllCount(fichaejecucion);
	}

	/**
	 * Finds rows in the Fichaejecucion table using like.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Fichaejecucion> findAllLike(Fichaejecucion fichaejecucion,
			Pagination pagination, Boolean startsWith) {
		return (List<Fichaejecucion>) this.fichaejecucionDao.findAllLike(
				fichaejecucion, pagination, startsWith);
	}

	/**
	 * Counts rows in the Fichaejecucion table using like.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Fichaejecucion fichaejecucion,
			Boolean startsWith) {
		return this.fichaejecucionDao.findAllLikeCount(fichaejecucion,
				startsWith);
	}

	/**
	 * Deletes a single row in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Fichaejecucion fichaejecucion) {
		this.fichaejecucionDao.remove(fichaejecucion);
	}

	/**
	 * Deletes multiple rows in the Fichaejecucion table.
	 * 
	 * @param fichaejecucionList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Fichaejecucion> fichaejecucionList) {
		for (Fichaejecucion fichaejecucionAux : fichaejecucionList) {
			this.fichaejecucionDao.remove(fichaejecucionAux);
		}
	}

	/**
	 * Inserts a single row in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @return Fichaejecucion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Fichaejecucion nuevaEjecucionFicha(Fichaejecucion fichaejecucion) {
		// Se comprobara que las fechas/horas introducidas no son incongruentes
		// con otras ejecuciones de ese tecnico y ficha
		// la fecha de inicio no puede estar entre la fecha inicio y fecha fin
		// de otra ejecucion
		// la fecha de fin no puede estar entre la fecha inicio y fecha fin de
		// otra ejecucion
		Fichaejecucion fichaEncontrado = new Fichaejecucion();

		fichaEncontrado = this.fichaejecucionDao
				.fechasEjecCorrectas(fichaejecucion);
		// fichaEncontrado =
		if (fichaEncontrado != null) {
			// Ha encontrado al menos un registro
			return null;
		} else {
			// Está correcto. Damos de alta la nueva ejecucion
			return this.fichaejecucionDao.add(fichaejecucion);
		}

	}

	/**
	 * Inserts a single row in the Fichaejecucion table.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @return Fichaejecucion
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Fichaejecucion modificarEjecucionFicha(Fichaejecucion fichaejecucion) {
		// Se comprobara que las fechas/horas introducidas no son incongruentes
		// con otras ejecuciones de ese tecnico y ficha
		// la fecha de inicio no puede estar entre la fecha inicio y fecha fin
		// de otra ejecucion
		// la fecha de fin no puede estar entre la fecha inicio y fecha fin de
		// otra ejecucion
		Fichaejecucion fichaEncontrado = new Fichaejecucion();

		fichaEncontrado = this.fichaejecucionDao
				.fechasEjecCorrectas(fichaejecucion);
		// fichaEncontrado =
		if (fichaEncontrado != null) {
			// Ha encontrado al menos un registro
			return null;
		} else {
			// Está correcto. Damos de alta la nueva ejecucion
			return this.fichaejecucionDao.modificarFechasEjec(fichaejecucion);
		}

	}

	/**
	 * Calcula el tiempo total de ejecucion de una ficha tecnico.y actualiza el
	 * campo TIEMPOREAL de la tabla FICHATECNICOS
	 * 
	 * @param idFichaTec
	 *            Integer
	 * @return Integer
	 */
	public Boolean recalcularTiempoFichaTecnico(Integer idFichaTec) {
		return this.fichaejecucionDao.recalcularTiempoFichaTecnico(idFichaTec);
	}
}
