package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.FichaDao;
import com.ejie.aa20b.dao.FichatecnicoDao;
import com.ejie.x38.dto.Pagination;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.model.Tecnicos;

/**
 * FichaServiceImpl generated by UDA, 10-mar-2015 10:12:57.
 * 
 * @author UDA
 */

@Service(value = "fichaService")
public class FichaServiceImpl implements FichaService {

	@Autowired
	private FichaDao fichaDao;

	@Autowired
	private FichatecnicoDao fichatecnicoDao;

	/**
	 * Inserts a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ficha add(Ficha ficha) {
		return this.fichaDao.add(ficha);
	}

	/**
	 * Updates a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ficha update(Ficha ficha) {
		return this.fichaDao.update(ficha);
	}

	@Transactional(rollbackFor = Throwable.class)
	public Ficha actualizarFechaPlanificacion(Ficha ficha) {
		return this.fichaDao.actualizarFechaPlanificacion(ficha);
	}

	/**
	 * Updates a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ficha actualizarUUIDficha(Ficha ficha) {
		return this.fichaDao.actualizarUUIDficha(ficha);
	}

	/**
	 * Finds a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	public Ficha find(Ficha ficha) {
		return (Ficha) this.fichaDao.find(ficha);
	}

	public Ficha findFichaByGuid(Ficha ficha) {
		return (Ficha) this.fichaDao.findFichaByGuid(ficha);
	}

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Ficha> findAll(Ficha ficha, Pagination pagination) {
		return (List<Ficha>) this.fichaDao.findAll(ficha, pagination);
	}

	public List<Ficha> findAllpendientes(Ficha ficha, Pagination pagination) {
		return (List<Ficha>) this.fichaDao.findAllpendientes(ficha, pagination);
	}

	/**
	 * Counts rows in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Long
	 */
	public Long findAllCount(Ficha ficha) {
		return this.fichaDao.findAllCount(ficha);
	}

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Ficha> findAllLike(Ficha ficha, Pagination pagination,
			Boolean startsWith) {
		return (List<Ficha>) this.fichaDao.findAllLike(ficha, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Ficha ficha, Boolean startsWith) {
		return this.fichaDao.findAllLikeCount(ficha, startsWith);
	}

	/**
	 * Deletes a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Ficha ficha) {
		this.fichaDao.remove(ficha);
	}

	/**
	 * Deletes multiple rows in the Ficha table.
	 * 
	 * @param fichaList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Ficha> fichaList) {
		for (Ficha fichaAux : fichaList) {
			this.fichaDao.remove(fichaAux);
		}
	}

	public ArrayList<TablaInformes> montarSelectTablaFicha(String idioma,
			Ficha filtro) {
		return this.fichaDao.montarSelectTablaFicha(idioma, filtro);
	}

	public ArrayList<TablaInformes> montarSelectTablaFichaTecnicos(
			String idioma, Ficha filtro) {
		return this.fichaDao.montarSelectTablaFichaTecnicos(idioma, filtro);
	}

	/**
	 * Updates a single row in the Ficha table.
	 * 
	 * @param idFicha
	 *            Integer
	 * @return Ficha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ficha finalizarFicha(Integer idFicha) {
		// Obtener la fecha de ejecucion y el tiempo Real. Fecha Maxima de la
		// tabla de fichaTecnicos y suma de tiempo real de todos los tecnicos

		// Obtener tiempo real
		Long totalTiempo = this.fichatecnicoDao.obtenerTiempoEjecucion(idFicha);

		Ficha ficha = new Ficha();

		ficha.setIdficha(idFicha);
		ficha.setTiemporeal(totalTiempo);

		// Obtener fecha Maxima

		Ficha fichaEjec = new Ficha();
		fichaEjec = this.fichaDao.obtenerFechaEjecucion(ficha);

		ficha.setFeejec(fichaEjec.getFeejec());
		// Actualizar el ficha con los datos obtenidos

		return this.fichaDao.finalizarFicha(ficha);

	}

	@Transactional(rollbackFor = Throwable.class)
	public Ficha finalizarFichaProceso(Ficha ficha) {
		// Obtener la fecha de ejecucion y el tiempo Real. Fecha Maxima de la
		// tabla de fichaTecnicos y suma de tiempo real de todos los tecnicos

		// Obtener tiempo real
		Long totalTiempo = this.fichatecnicoDao.obtenerTiempoEjecucion(ficha
				.getIdficha());

		ficha.setTiemporeal(totalTiempo);

		// Obtener fecha Maxima

		Ficha fichaEjec = new Ficha();
		fichaEjec = this.fichaDao.obtenerFechaEjecucion(ficha);

		if (fichaEjec != null && fichaEjec.getFeejec() != null) {
			ficha.setFeejec(fichaEjec.getFeejec());
		}
		// Actualizar el ficha con los datos obtenidos

		return this.fichaDao.finalizarFicha(ficha);

	}

	/**
	 * abre el ficha padre y todos los hijos (EJECUTADO=0).
	 * 
	 * @param idFicha
	 *            Integer
	 * @return Ficha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ficha abrirFicha(Integer idFicha) {
		// abre el ficha padre y los hijos

		Ficha ficha = new Ficha();
		ficha.setIdficha(idFicha);

		// Actualizar el ficha con los datos obtenidos

		return this.fichaDao.abrirFicha(ficha);

	}

	/**
	 * Finds a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	public Ficha findFicha(Ficha ficha) {
		return (Ficha) this.fichaDao.findFicha(ficha);
	}

	/**
	 * Calcula el numero de partes preventivos(fichas) pendientes de asignar
	 * tecnico.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	public Long calculaPrevPendATC(String UIDUsuario, Integer idServicio,
			Integer idClase) {
		return this.fichaDao
				.calculaPrevPendATC(UIDUsuario, idServicio, idClase);
	}

	/**
	 * Calcula el numero de partes preventivos(fichas) asignados pendientes de
	 * ejecutar
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	public Long calculaPrevAsigPendEjec(String UIDUsuario, Integer idServicio,
			Integer idClase) {
		return this.fichaDao.calculaPrevAsigPendEjec(UIDUsuario, idServicio,
				idClase);
	}

	/**
	 * marca EnvioMail single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return
	 */
	public void marcarEnvioMail(Ficha ficha) {
		this.fichaDao.marcarEnvioMail(ficha);
	}

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param fichas
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	public List<Ficha> obtenerPrevPendAsignar(Ficha fichas,
			Pagination pagination, Boolean startsWith, String UIDUsuario) {

		return (List<Ficha>) this.fichaDao.obtenerPrevPendAsignar(fichas,
				pagination, startsWith, UIDUsuario);

	}

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param fichas
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	public List<Ficha> obtenerFichasGrid(Ficha fichas, Pagination pagination,
			Boolean startsWith, String UIDUsuario) {

		return (List<Ficha>) this.fichaDao.obtenerFichasGrid(fichas,
				pagination, startsWith, UIDUsuario);

	}

	public List<Ficha> obtenerDatosAgendaGrid(Ficha fichas,
			Pagination pagination, Boolean startsWith, String UIDUsuario,
			boolean conTecnicos, List<Tecnicos> listaTecnicosBusq) {

		return (List<Ficha>) this.fichaDao.obtenerDatosAgendaGrid(fichas,
				pagination, startsWith, UIDUsuario, conTecnicos,
				listaTecnicosBusq);

	}

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return Long
	 */
	public Long obtenerPrevPendAsignarCount(Ficha ficha, Boolean startsWith,
			String sUIDUsuario) {
		return this.fichaDao.obtenerPrevPendAsignarCount(ficha, startsWith,
				sUIDUsuario);
	}

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return Long
	 */
	public Long obtenerFichasGridCount(Ficha ficha, Boolean startsWith,
			String sUIDUsuario) {
		return this.fichaDao.obtenerFichasGridCount(ficha, startsWith,
				sUIDUsuario);
	}

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param fichas
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	public List<Ficha> obtenerPrevAsigPendEjec(Ficha fichas,
			Pagination pagination, Boolean startsWith, String UIDUsuario) {

		return (List<Ficha>) this.fichaDao.obtenerPrevAsigPendEjec(fichas,
				pagination, startsWith, UIDUsuario);

	}

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return Long
	 */
	public Long obtenerPrevAsigPendEjecCount(Ficha ficha, Boolean startsWith,
			String sUIDUsuario) {
		return this.fichaDao.obtenerPrevAsigPendEjecCount(ficha, startsWith,
				sUIDUsuario);
	}

	public ArrayList<TablaInformes> montarSelectTablaPrevPendAsignar(
			String idioma, Ficha filtro, String UIDUsuario) {
		return this.fichaDao.montarSelectTablaPrevPendAsignar(idioma, filtro,
				UIDUsuario);
	}

	public ArrayList<TablaInformes> montarSelectTablaPrevAsigPendEjec(
			String idioma, Ficha filtro, String UIDUsuario) {
		return this.fichaDao.montarSelectTablaPrevAsigPendEjec(idioma, filtro,
				UIDUsuario);
	}

	public ArrayList<TablaInformes> montarSelectTablaPreventivos(String idioma,
			Ficha filtro, String UIDUsuario) {
		return this.fichaDao.montarSelectTablaPreventivos(idioma, filtro,
				UIDUsuario);
	}

	public ArrayList<TablaInformes> montarSelectTablaDiarioFichas(
			String idioma, Ficha filtro, String UIDUsuario) {
		return this.fichaDao.montarSelectTablaDiarioFichas(idioma, filtro,
				UIDUsuario);
	}

	public ArrayList<TablaInformes> montarSelectTablaFichasEjecutadas(
			String idioma, Ficha filtro, String UIDUsuario) {
		return this.fichaDao.montarSelectTablaFichasEjecutadas(idioma, filtro,
				UIDUsuario);
	}

	public ArrayList<TablaInformes> montarSelectTablaFichasEjecutadasDetalle(
			String idioma, Ficha filtro, String UIDUsuario) {
		return this.fichaDao.montarSelectTablaFichasEjecutadasDetalle(idioma,
				filtro, UIDUsuario);
	}

	/**
	 * Updates a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Ficha modificarObserv(Ficha ficha) {
		return this.fichaDao.modificarObserv(ficha);
	}
}
