package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;

import java.util.ArrayList;
import java.util.List;

import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.model.Tecnicos;

/**
 * FichaService generated by UDA, 10-mar-2015 10:12:57.
 * 
 * @author UDA
 */

public interface FichaService {

	/**
	 * Inserts a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha add(Ficha ficha);

	/**
	 * Updates a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha update(Ficha ficha);

	Ficha actualizarFechaPlanificacion(Ficha ficha);

	Ficha actualizarUUIDficha(Ficha ficha);

	/**
	 * Finds a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha find(Ficha ficha);

	Ficha findFichaByGuid(Ficha ficha);

	/**
	 * Finds a List of rows in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Ficha> findAll(Ficha ficha, Pagination pagination);

	List<Ficha> findAllpendientes(Ficha ficha, Pagination pagination);

	/**
	 * Counts rows in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Long
	 */
	Long findAllCount(Ficha ficha);

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Ficha> findAllLike(Ficha ficha, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Ficha ficha, Boolean startsWith);

	/**
	 * Deletes a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return
	 */
	void remove(Ficha ficha);

	/**
	 * Deletes multiple rows in the Ficha table.
	 * 
	 * @param fichaList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Ficha> fichaList);

	/**
	 * montarSelectTablaFicha.
	 * 
	 * @param idioma
	 *            String
	 * @param filtro
	 *            Ficha
	 * @return ArrayList
	 */
	ArrayList<TablaInformes> montarSelectTablaFicha(String idioma, Ficha filtro);

	/**
	 * montarSelectTablaFichaTecnicos.
	 * 
	 * @param idioma
	 *            String
	 * @param filtro
	 *            Ficha
	 * @return ArrayList
	 */
	ArrayList<TablaInformes> montarSelectTablaFichaTecnicos(String idioma,
			Ficha filtro);

	/**
	 * Updates a single row in the Ficha table.
	 * 
	 * @param idFicha
	 *            Integer
	 * @return Ficha
	 */
	Ficha finalizarFicha(Integer idFicha);

	Ficha finalizarFichaProceso(Ficha ficha);

	/**
	 * abre el ficha padre y todos los hijos (EJECUTADO=0).
	 * 
	 * @param idFicha
	 *            Integer
	 * @return Ficha
	 */
	Ficha abrirFicha(Integer idFicha);

	/**
	 * Finds a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha findFicha(Ficha ficha);

	/**
	 * Calcula el numero de partes preventivos(fichas) pendientes de asignar
	 * tecnico.
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	Long calculaPrevPendATC(String UIDUsuario, Integer idServicio,
			Integer idClase);

	/**
	 * Calcula el numero de partes preventivos(fichas) asignados pendientes de
	 * ejecutar
	 * 
	 * @param UIDUsuario
	 *            String
	 * @param idServicio
	 *            Integer
	 * @return Long
	 */
	Long calculaPrevAsigPendEjec(String UIDUsuario, Integer idServicio,
			Integer idClase);

	/**
	 * marca EnvioMail single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return
	 */
	void marcarEnvioMail(Ficha ficha);

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param fichas
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	List<Ficha> obtenerPrevPendAsignar(Ficha fichas, Pagination pagination,
			Boolean startsWith, String UIDUsuario);

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param fichas
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	List<Ficha> obtenerFichasGrid(Ficha fichas, Pagination pagination,
			Boolean startsWith, String UIDUsuario);

	List<Ficha> obtenerDatosAgendaGrid(Ficha fichas, Pagination pagination,
			Boolean startsWith, String UIDUsuario, boolean conTecnicos,
			List<Tecnicos> listaTecnicosBusq);

	/**
	 * Finds rows in the Ficha table using like.
	 * 
	 * @param fichas
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return List
	 */
	List<Ficha> obtenerPrevAsigPendEjec(Ficha fichas, Pagination pagination,
			Boolean startsWith, String UIDUsuario);

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return Long
	 */
	Long obtenerPrevPendAsignarCount(Ficha ficha, Boolean startsWith,
			String sUIDUsuario);

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return Long
	 */
	Long obtenerFichasGridCount(Ficha ficha, Boolean startsWith,
			String sUIDUsuario);

	/**
	 * Counts rows in the Ficha table using like.
	 * 
	 * @param ficha
	 *            Ficha
	 * @param startsWith
	 *            Boolean
	 * @param sUIDUsuario
	 *            String
	 * @return Long
	 */
	Long obtenerPrevAsigPendEjecCount(Ficha ficha, Boolean startsWith,
			String sUIDUsuario);

	ArrayList<TablaInformes> montarSelectTablaPrevPendAsignar(String idioma,
			Ficha filtro, String UIDUsuario);

	ArrayList<TablaInformes> montarSelectTablaPrevAsigPendEjec(String idioma,
			Ficha filtro, String UIDUsuario);

	ArrayList<TablaInformes> montarSelectTablaPreventivos(String idioma,
			Ficha filtro, String UIDUsuario);

	ArrayList<TablaInformes> montarSelectTablaDiarioFichas(String idioma,
			Ficha filtro, String UIDUsuario);

	ArrayList<TablaInformes> montarSelectTablaFichasEjecutadas(String idioma,
			Ficha filtro, String UIDUsuario);

	ArrayList<TablaInformes> montarSelectTablaFichasEjecutadasDetalle(
			String idioma, Ficha filtro, String UIDUsuario);

	/**
	 * Updates a single row in the Ficha table.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	Ficha modificarObserv(Ficha ficha);

}
