package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.EspacioDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Espacio;

/**
 * EspacioServiceImpl generated by UDA, 28-nov-2014 11:49:06.
 * 
 * @author UDA
 */

@Service(value = "espacioService")
public class EspacioServiceImpl implements EspacioService {

	@Autowired
	private EspacioDao espacioDao;

	/**
	 * Inserts a single row in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return Espacio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Espacio add(Espacio espacio) {
		return this.espacioDao.add(espacio);
	}

	/**
	 * Updates a single row in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return Espacio
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Espacio update(Espacio espacio) {
		return this.espacioDao.update(espacio);
	}

	/**
	 * Finds a single row in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return Espacio
	 */
	public Espacio find(Espacio espacio) {
		return (Espacio) this.espacioDao.find(espacio);
	}

	/**
	 * Finds a List of rows in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Espacio> findAll(Espacio espacio, Pagination pagination) {
		return (List<Espacio>) this.espacioDao.findAll(espacio, pagination);
	}

	/**
	 * Counts rows in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return Long
	 */
	public Long findAllCount(Espacio espacio) {
		return this.espacioDao.findAllCount(espacio);
	}

	/**
	 * Finds rows in the Espacio table using like.
	 * 
	 * @param espacio
	 *            Espacio
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Espacio> findAllLike(Espacio espacio, Pagination pagination,
			Boolean startsWith) {
		return (List<Espacio>) this.espacioDao.findAllLike(espacio, pagination,
				startsWith);
	}

	/**
	 * Counts rows in the Espacio table using like.
	 * 
	 * @param espacio
	 *            Espacio
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Espacio espacio, Boolean startsWith) {
		return this.espacioDao.findAllLikeCount(espacio, startsWith);
	}

	/**
	 * Deletes a single row in the Espacio table.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Espacio espacio) {
		this.espacioDao.remove(espacio);
	}

	/**
	 * Deletes multiple rows in the Espacio table.
	 * 
	 * @param espacioList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Espacio> espacioList) {
		for (Espacio espacioAux : espacioList) {
			this.espacioDao.remove(espacioAux);
		}
	}

	/**
	 * obtener los espacios que esten en situación de Alta.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return List
	 */
	public List<Espacio> obtenerEspaciosAlta(Espacio espacio) {
		return (List<Espacio>) this.espacioDao.obtenerEspaciosAlta(espacio);
	}
}
