package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.EdificiosverDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Edificiosver;

/**
 * EdificiosverServiceImpl generated by UDA, 13-mar-2015 12:21:16.
 * 
 * @author UDA
 */

@Service(value = "edificiosverService")
public class EdificiosverServiceImpl implements EdificiosverService {

	@Autowired
	private EdificiosverDao edificiosverDao;

	/**
	 * Inserts a single row in the Edificiosver table.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Edificiosver
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Edificiosver add(Edificiosver edificiosver) {
		return this.edificiosverDao.add(edificiosver);
	}

	/**
	 * Updates a single row in the Edificiosver table.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Edificiosver
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Edificiosver update(Edificiosver edificiosver) {
		return this.edificiosverDao.update(edificiosver);
	}

	/**
	 * Finds a single row in the Edificiosver table.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Edificiosver
	 */
	public Edificiosver find(Edificiosver edificiosver) {
		return (Edificiosver) this.edificiosverDao.find(edificiosver);
	}

	/**
	 * Finds a List of rows in the Edificiosver table.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Edificiosver> findAll(Edificiosver edificiosver,
			Pagination pagination) {
		return (List<Edificiosver>) this.edificiosverDao.findAll(edificiosver,
				pagination);
	}

	/**
	 * Counts rows in the Edificiosver table.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Long
	 */
	public Long findAllCount(Edificiosver edificiosver) {
		return this.edificiosverDao.findAllCount(edificiosver);
	}

	/**
	 * Finds rows in the Edificiosver table using like.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Edificiosver> findAllLike(Edificiosver edificiosver,
			Pagination pagination, Boolean startsWith) {
		return (List<Edificiosver>) this.edificiosverDao.findAllLike(
				edificiosver, pagination, startsWith);
	}

	/**
	 * Counts rows in the Edificiosver table using like.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Edificiosver edificiosver, Boolean startsWith) {
		return this.edificiosverDao.findAllLikeCount(edificiosver, startsWith);
	}

	/**
	 * Deletes a single row in the Edificiosver table.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Edificiosver edificiosver) {
		this.edificiosverDao.remove(edificiosver);
	}

	/**
	 * Deletes multiple rows in the Edificiosver table.
	 * 
	 * @param edificiosverList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Edificiosver> edificiosverList) {
		for (Edificiosver edificiosverAux : edificiosverList) {
			this.edificiosverDao.remove(edificiosverAux);
		}
	}

	/**
	 * Finds a List of rows in the Edificiosver table.
	 * 
	 * @param idUsuario
	 *            String
	 * @return List
	 */
	public List<Edificiosver> obtenerEdificiosUsuarioAsignados(String idUsuario) {
		return (List<Edificiosver>) this.edificiosverDao
				.obtenerEdificiosUsuarioAsignados(idUsuario);
	}

	/**
	 * Finds a List of rows in the Edificiosver table.
	 * 
	 * @param idUsuario
	 *            String
	 * @return List
	 */
	public List<Edificiosver> obtenerEdificiosUsuarioLibres(String idUsuario) {
		return (List<Edificiosver>) this.edificiosverDao
				.obtenerEdificiosUsuarioLibres(idUsuario);
	}

	/**
	 * Finds a List of rows in the Edificiosver table.
	 * 
	 * @param idUsuario
	 *            String
	 * @return List
	 */
	public List<Edificiosver> obtenerEdificiosUsuarioNOVer(String idUsuario,
			String territorio) {
		return (List<Edificiosver>) this.edificiosverDao
				.obtenerEdificiosUsuarioNOVer(idUsuario, territorio);
	}

	/**
	 * Finds a List of rows in the Edificiosver table.
	 * 
	 * @param idUsuario
	 *            String
	 * @return List
	 */
	public List<Edificiosver> obtenerEdificiosUsuarioVer(String idUsuario,
			String territorio) {
		return (List<Edificiosver>) this.edificiosverDao
				.obtenerEdificiosUsuarioVer(idUsuario, territorio);
	}

	/**
	 * marca el edificio para ver.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Edificiosver
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Edificiosver marcarVer(Edificiosver edificiosver) {
		return this.edificiosverDao.marcarVer(edificiosver);
	}

	/**
	 * marca el edificio para NO ver.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Edificiosver
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Edificiosver marcarNOVer(Edificiosver edificiosver) {
		return this.edificiosverDao.marcarNOVer(edificiosver);
	}
}
