package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Edificiosver;

/**
 * EdificiosverService generated by UDA, 13-mar-2015 12:21:16.
 * 
 * @author UDA
 */

public interface EdificiosverService {

	/**
	 * Inserts a single row in the Edificiosver table.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Edificiosver
	 */
	Edificiosver add(Edificiosver edificiosver);

	/**
	 * Updates a single row in the Edificiosver table.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Edificiosver
	 */
	Edificiosver update(Edificiosver edificiosver);

	/**
	 * Finds a single row in the Edificiosver table.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Edificiosver
	 */
	Edificiosver find(Edificiosver edificiosver);

	/**
	 * Finds a List of rows in the Edificiosver table.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Edificiosver> findAll(Edificiosver edificiosver, Pagination pagination);

	/**
	 * Counts rows in the Edificiosver table.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Long
	 */
	Long findAllCount(Edificiosver edificiosver);

	/**
	 * Finds rows in the Edificiosver table using like.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Edificiosver> findAllLike(Edificiosver edificiosver,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Edificiosver table using like.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Edificiosver edificiosver, Boolean startsWith);

	/**
	 * Deletes a single row in the Edificiosver table.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return
	 */
	void remove(Edificiosver edificiosver);

	/**
	 * Deletes multiple rows in the Edificiosver table.
	 * 
	 * @param edificiosverList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Edificiosver> edificiosverList);

	/**
	 * Finds a List of rows in the Edificiosver table.
	 * 
	 * @param idUsuario
	 *            String
	 * @return List
	 */
	List<Edificiosver> obtenerEdificiosUsuarioAsignados(String idUsuario);

	/**
	 * Finds a List of rows in the Edificiosver table.
	 * 
	 * @param idUsuario
	 *            String
	 * @return List
	 */
	List<Edificiosver> obtenerEdificiosUsuarioLibres(String idUsuario);

	/**
	 * Finds a List of rows in the Edificiosver table.
	 * 
	 * @param idUsuario
	 *            String
	 * @return List
	 */
	List<Edificiosver> obtenerEdificiosUsuarioNOVer(String idUsuario,
			String territorio);

	/**
	 * Finds a List of rows in the Edificiosver table.
	 * 
	 * @param idUsuario
	 *            String
	 * @return List
	 */
	List<Edificiosver> obtenerEdificiosUsuarioVer(String idUsuario,
			String territorio);

	/**
	 * marca el edificio para ver.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Edificiosver
	 */
	public Edificiosver marcarVer(Edificiosver edificiosver);

	/**
	 * marca el edificio para NO ver.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Edificiosver
	 */

	public Edificiosver marcarNOVer(Edificiosver edificiosver);
}
