package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.EdificiosXlnetDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.ldap.SecurityHelpperXLNets;
import com.ejie.aa20b.model.EdificiosXlnet;

/**
 * EdificiosXlnetServiceImpl generated by UDA, 13-feb-2015 12:34:51.
 * 
 * @author UDA
 */

@Service(value = "edificiosXlnetService")
public class EdificiosXlnetServiceImpl implements EdificiosXlnetService {

	@Autowired
	private EdificiosXlnetDao edificiosXlnetDao;

	/**
	 * Inserts a single row in the EdificiosXlnet table.
	 * 
	 * @param edificiosXlnet
	 *            EdificiosXlnet
	 * @return EdificiosXlnet
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EdificiosXlnet add(EdificiosXlnet edificiosXlnet) {
		return this.edificiosXlnetDao.add(edificiosXlnet);
	}

	/**
	 * Updates a single row in the EdificiosXlnet table.
	 * 
	 * @param edificiosXlnet
	 *            EdificiosXlnet
	 * @return EdificiosXlnet
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EdificiosXlnet update(EdificiosXlnet edificiosXlnet) {
		return this.edificiosXlnetDao.update(edificiosXlnet);
	}

	/**
	 * Finds a single row in the EdificiosXlnet table.
	 * 
	 * @param edificiosXlnet
	 *            EdificiosXlnet
	 * @return EdificiosXlnet
	 */
	public EdificiosXlnet find(EdificiosXlnet edificiosXlnet) {
		return (EdificiosXlnet) this.edificiosXlnetDao.find(edificiosXlnet);
	}

	/**
	 * Finds a List of rows in the EdificiosXlnet table.
	 * 
	 * @param edificiosXlnet
	 *            EdificiosXlnet
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EdificiosXlnet> findAll(EdificiosXlnet edificiosXlnet,
			Pagination pagination) {
		return (List<EdificiosXlnet>) this.edificiosXlnetDao.findAll(
				edificiosXlnet, pagination);
	}

	/**
	 * Counts rows in the EdificiosXlnet table.
	 * 
	 * @param edificiosXlnet
	 *            EdificiosXlnet
	 * @return Long
	 */
	public Long findAllCount(EdificiosXlnet edificiosXlnet) {
		return this.edificiosXlnetDao.findAllCount(edificiosXlnet);
	}

	/**
	 * Finds rows in the EdificiosXlnet table using like.
	 * 
	 * @param edificiosXlnet
	 *            EdificiosXlnet
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<EdificiosXlnet> findAllLike(EdificiosXlnet edificiosXlnet,
			Pagination pagination, Boolean startsWith) {
		return (List<EdificiosXlnet>) this.edificiosXlnetDao.findAllLike(
				edificiosXlnet, pagination, startsWith);
	}

	/**
	 * Counts rows in the EdificiosXlnet table using like.
	 * 
	 * @param edificiosXlnet
	 *            EdificiosXlnet
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(EdificiosXlnet edificiosXlnet,
			Boolean startsWith) {
		return this.edificiosXlnetDao.findAllLikeCount(edificiosXlnet,
				startsWith);
	}

	/**
	 * Deletes a single row in the EdificiosXlnet table.
	 * 
	 * @param edificiosXlnet
	 *            EdificiosXlnet
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EdificiosXlnet edificiosXlnet) {
		this.edificiosXlnetDao.remove(edificiosXlnet);
	}

	/**
	 * Deletes multiple rows in the EdificiosXlnet table.
	 * 
	 * @param edificiosXlnetList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<EdificiosXlnet> edificiosXlnetList) {
		for (EdificiosXlnet edificiosXlnetAux : edificiosXlnetList) {
			this.edificiosXlnetDao.remove(edificiosXlnetAux);
		}
	}

	/**
	 * vacia la tabla de EdificiosXLNET y la vuelve a cargar con los edificios
	 * que se obtienen de XLNET.
	 * 
	 * @return Boolean
	 */
	// @Transactional(rollbackFor = Throwable.class)
	public Boolean getListaEdificiosXLNETs() {

		// Primero vaciamos la tabla de edificios XLNET
		this.edificiosXlnetDao.vaciarTablaEdificiosXLNET();

		// Ahora se cargan los edificios que se sacan de XLNET
		String filtroEdif;
		try {
			for (int i = 0; i < 10; i++) {
				// la busqueda de edificios por provincias o por cualquier otro
				// campo que no sea el n38uidedificio es lentisima.
				// La busqueda por n38uidedificio no adminte el asterisco. Para
				// encontrar todos los edificios, busco los que empiezan por 0*,
				// 1*, 2*, ...., hasta 9*
				filtroEdif = "n38uidedificio=" + i + "*";
				new SecurityHelpperXLNets().getListaEdificiosXLNETs(
						this.edificiosXlnetDao, filtroEdif);
			}
			return true;
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}

	}

}
