package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.EdifEstrucDao;
import com.ejie.aa20b.dao.EdificiosDao;
import com.ejie.aa20b.dao.TecnicoEdifDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.EdifEstruc;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.util.Aa20bConstantes;

/**
 * EdificiosServiceImpl generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

@Service(value = "edificiosService")
public class EdificiosServiceImpl implements EdificiosService {

	@Autowired
	private EdificiosDao edificiosDao;

	@Autowired
	private TecnicoEdifDao tecnicoEdifDao;

	@Autowired
	private EdifEstrucDao edifEstrucDao;

	/**
	 * Inserts a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Edificios
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Edificios add(Edificios edificios) {
		return this.edificiosDao.add(edificios);
	}

	/**
	 * Inserts a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Edificios
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Edificios nuevoEdificio(Edificios edificios) {
		// Añadir registro en la tabla de EDIF_ESTRUCT con el edificio y zona=0
		// y planta=0

		EdifEstruc edifEstruc = new EdifEstruc();
		edifEstruc.setIdedificio(edificios.getIdedificio());
		edifEstruc.setIdplanta(Integer.toString(Aa20bConstantes.SIN_PLANTAS)); // INMA
																				// -
																				// ESTO
																				// LO
		// HE CAMBIADO
		// PERO YA NO SE
		// USA.
		edifEstruc.setIdzona(Aa20bConstantes.SIN_ZONAS);
		this.edifEstrucDao.add(edifEstruc);

		return this.edificiosDao.add(edificios);

	}

	/**
	 * Updates a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Edificios
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Edificios update(Edificios edificios) {
		// Si viene baja=1 se eliminaran todos los registros de la tabal
		// TECNICO-EDIF para este edificio

		if (edificios != null && edificios.getBaja() != null) {
			if (edificios.getBaja().equals("1")) {
				this.tecnicoEdifDao.eliminarTecEdif(edificios.getIdedificio());
			}
		}

		return this.edificiosDao.update(edificios);
	}

	@Override
	public Edificios actualizarUUIDedificio(Edificios edificio) {
		// TODO Auto-generated method stub
		return this.edificiosDao.actualizarUUIDedificio(edificio);
	}

	/**
	 * Finds a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Edificios
	 */
	public Edificios find(Edificios edificios) {
		return (Edificios) this.edificiosDao.find(edificios);
	}

	public Edificios findByGUID(Edificios edificios) {
		return (Edificios) this.edificiosDao.findByGUID(edificios);
	}

	/**
	 * Finds a single row in the Edificios table.
	 * 
	 * @param idEdificio
	 *            String
	 * @return Edificios
	 */
	public Edificios obtenerEdificio(String idEdificio) {
		return (Edificios) this.edificiosDao.obtenerEdificio(idEdificio);
	}

	/**
	 * Finds a List of rows in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Edificios> findAll(Edificios edificios, Pagination pagination) {
		return (List<Edificios>) this.edificiosDao.findAll(edificios,
				pagination);
	}

	/**
	 * Counts rows in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Long
	 */
	public Long findAllCount(Edificios edificios) {
		return this.edificiosDao.findAllCount(edificios);
	}

	/**
	 * Finds rows in the Edificios table using like.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Edificios> findAllLike(Edificios edificios,
			Pagination pagination, Boolean startsWith) {
		return (List<Edificios>) this.edificiosDao.findAllLike(edificios,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Edificios table using like.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Edificios edificios, Boolean startsWith) {
		return this.edificiosDao.findAllLikeCount(edificios, startsWith);
	}

	/**
	 * Obtener los edificios asociados a un usuario.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param uIDUsuario
	 *            String
	 * @return List
	 */
	public List<Edificios> obtenerEdificiosUsuario(Edificios edificios,
			Pagination pagination, Boolean startsWith, String uIDUsuario) {
		return (List<Edificios>) this.edificiosDao.obtenerEdificiosUsuario(
				edificios, pagination, startsWith, uIDUsuario);
	}

	/**
	 * Obtener los edificios
	 * 
	 * @param edificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Edificios> obtenerEdificios(Edificios edificios,
			Pagination pagination, Boolean startsWith) {
		return (List<Edificios>) this.edificiosDao.obtenerEdificios(edificios,
				pagination, startsWith);
	}

	/**
	 * Counts Edificios asociados a un usuario.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	public Long obtenerEdificiosUsuarioCount(Edificios edificios,
			Boolean startsWith, String uIDUsuario) {
		return this.edificiosDao.obtenerEdificiosUsuarioCount(edificios,
				startsWith, uIDUsuario);
	}

	/**
	 * Counts Edificios
	 * 
	 * @param edificios
	 *            Edificios
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long obtenerEdificiosCount(Edificios edificios, Boolean startsWith) {
		return this.edificiosDao.obtenerEdificiosCount(edificios, startsWith);
	}

	/**
	 * Deletes a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Edificios edificios) {
		this.edificiosDao.remove(edificios);
	}

	/**
	 * Deletes multiple rows in the Edificios table.
	 * 
	 * @param edificiosList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Edificios> edificiosList) {
		for (Edificios edificiosAux : edificiosList) {
			this.edificiosDao.remove(edificiosAux);
		}
	}

	/**
	 * Si no existe el edificio lo da de alta.
	 * 
	 * @param codEdificio
	 *            String
	 * @return Boolean
	 */
	public Boolean comprobarExisteEdificio(String codEdificio) {
		return this.edificiosDao.comprobarExisteEdificio(codEdificio);
	}

	/**
	 * Obtener de los Edificios asociados al UID PUESTO aquellos que estan
	 * asociados al tecnico seleccionado
	 * 
	 * @param idTecnico
	 *            Integer
	 * @param UIDPuesto
	 *            String
	 * @return List
	 */
	public List<Edificios> obtenerEdificiosTecnicoLibres(Integer idTecnico,
			String UIDPuesto) {
		return (List<Edificios>) this.edificiosDao
				.obtenerEdificiosTecnicoLibres(idTecnico, UIDPuesto);
	}

	/**
	 * Obtener los Edificios asociados al tecnico seleccionado
	 * 
	 * @param idTecnico
	 *            Integer
	 * @return List
	 */
	public List<Edificios> obtenerEdificiosTecnicoOcupados(Integer idTecnico) {
		return (List<Edificios>) this.edificiosDao
				.obtenerEdificiosTecnicoOcupados(idTecnico);
	}

	/**
	 * Finds a List of rows in the Edificios table.
	 * 
	 * @return List
	 */
	public List<Edificios> obtenerEdificiosConPlanos() {
		return (List<Edificios>) this.edificiosDao.obtenerEdificiosConPlanos();
	}

}
