package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Edificios;

/**
 * EdificiosService generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

public interface EdificiosService {

	/**
	 * Inserts a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Edificios
	 */
	Edificios add(Edificios edificios);

	/**
	 * Inserts a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Edificios
	 */
	Edificios nuevoEdificio(Edificios edificios);

	/**
	 * Updates a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Edificios
	 */
	Edificios update(Edificios edificios);

	Edificios actualizarUUIDedificio(Edificios edificio);

	/**
	 * Finds a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Edificios
	 */
	Edificios find(Edificios edificios);

	Edificios findByGUID(Edificios edificios);

	/**
	 * Finds a single row in the Edificios table.
	 * 
	 * @param idEdificio
	 *            String
	 * @return Edificios
	 */
	Edificios obtenerEdificio(String idEdificio);

	/**
	 * Finds a List of rows in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Edificios> findAll(Edificios edificios, Pagination pagination);

	/**
	 * Counts rows in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Long
	 */
	Long findAllCount(Edificios edificios);

	/**
	 * Finds rows in the Edificios table using like.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Edificios> findAllLike(Edificios edificios, Pagination pagination,
			Boolean startsWith);

	/**
	 * Counts rows in the Edificios table using like.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Edificios edificios, Boolean startsWith);

	/**
	 * Obtener los edificios asociados a un usuario.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @param uIDUsuario
	 *            String
	 * @return List
	 */
	List<Edificios> obtenerEdificiosUsuario(Edificios edificios,
			Pagination pagination, Boolean startsWith, String uIDUsuario);

	/**
	 * Obtener los edificios
	 * 
	 * @param edificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Edificios> obtenerEdificios(Edificios edificios,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts Edificios asociados a un usuario.
	 * 
	 * @param edificios
	 *            Edificios
	 * @param startsWith
	 *            Boolean
	 * @param UIDUsuario
	 *            String
	 * @return Long
	 */
	Long obtenerEdificiosUsuarioCount(Edificios edificios, Boolean startsWith,
			String uIDUsuario);

	/**
	 * Counts Edificios
	 * 
	 * @param edificios
	 *            Edificios
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long obtenerEdificiosCount(Edificios edificios, Boolean startsWith);

	/**
	 * Deletes a single row in the Edificios table.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return
	 */
	void remove(Edificios edificios);

	/**
	 * Deletes multiple rows in the Edificios table.
	 * 
	 * @param edificiosList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Edificios> edificiosList);

	/**
	 * Si no existe el edificio lo da de alta.
	 * 
	 * @param codEdificio
	 *            String
	 * @return Boolean
	 */
	public Boolean comprobarExisteEdificio(String codEdificio);

	/**
	 * Obtener de los Edificios asociados al UID PUESTO aquellos que estan
	 * asociados al tecnico seleccionado
	 * 
	 * @param idTecnico
	 *            Integer
	 * @param UIDPuesto
	 *            String
	 * @return List
	 */
	List<Edificios> obtenerEdificiosTecnicoLibres(Integer idTecnico,
			String UIDPuesto);

	/**
	 * Obtener los Edificios asociados al tecnico seleccionado
	 * 
	 * @param idTecnico
	 *            Integer
	 * @return List
	 */
	List<Edificios> obtenerEdificiosTecnicoOcupados(Integer idTecnico);

	/**
	 * Finds a List of rows in the Edificios table.
	 * 
	 * @return List
	 */
	List<Edificios> obtenerEdificiosConPlanos();

}
