package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.EdifEstrucDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.EdifEstruc;

/**
 * EdifEstrucServiceImpl generated by UDA, 18-feb-2015 9:05:57.
 * 
 * @author UDA
 */

@Service(value = "edifEstrucService")
public class EdifEstrucServiceImpl implements EdifEstrucService {

	@Autowired
	private EdifEstrucDao edifEstrucDao;

	/**
	 * Inserts a single row in the EdifEstruc table.
	 * 
	 * @param edifEstruc
	 *            EdifEstruc
	 * @return EdifEstruc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EdifEstruc add(EdifEstruc edifEstruc) {
		return this.edifEstrucDao.add(edifEstruc);
	}

	/**
	 * Updates a single row in the EdifEstruc table.
	 * 
	 * @param edifEstruc
	 *            EdifEstruc
	 * @return EdifEstruc
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EdifEstruc update(EdifEstruc edifEstruc) {
		return this.edifEstrucDao.update(edifEstruc);
	}

	/**
	 * Finds a single row in the EdifEstruc table.
	 * 
	 * @param edifEstruc
	 *            EdifEstruc
	 * @return EdifEstruc
	 */
	public EdifEstruc find(EdifEstruc edifEstruc) {
		return (EdifEstruc) this.edifEstrucDao.find(edifEstruc);
	}

	/**
	 * Finds a List of rows in the EdifEstruc table.
	 * 
	 * @param edifEstruc
	 *            EdifEstruc
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<EdifEstruc> findAll(EdifEstruc edifEstruc, Pagination pagination) {
		return (List<EdifEstruc>) this.edifEstrucDao.findAll(edifEstruc,
				pagination);
	}

	/**
	 * Counts rows in the EdifEstruc table.
	 * 
	 * @param edifEstruc
	 *            EdifEstruc
	 * @return Long
	 */
	public Long findAllCount(EdifEstruc edifEstruc) {
		return this.edifEstrucDao.findAllCount(edifEstruc);
	}

	/**
	 * Finds rows in the EdifEstruc table using like.
	 * 
	 * @param edifEstruc
	 *            EdifEstruc
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<EdifEstruc> findAllLike(EdifEstruc edifEstruc,
			Pagination pagination, Boolean startsWith) {
		return (List<EdifEstruc>) this.edifEstrucDao.findAllLike(edifEstruc,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the EdifEstruc table using like.
	 * 
	 * @param edifEstruc
	 *            EdifEstruc
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(EdifEstruc edifEstruc, Boolean startsWith) {
		return this.edifEstrucDao.findAllLikeCount(edifEstruc, startsWith);
	}

	/**
	 * Deletes a single row in the EdifEstruc table.
	 * 
	 * @param edifEstruc
	 *            EdifEstruc
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EdifEstruc edifEstruc) {
		this.edifEstrucDao.remove(edifEstruc);
	}

	/**
	 * Deletes multiple rows in the EdifEstruc table.
	 * 
	 * @param edifEstrucList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<EdifEstruc> edifEstrucList) {
		for (EdifEstruc edifEstrucAux : edifEstrucList) {
			this.edifEstrucDao.remove(edifEstrucAux);
		}
	}

	public void removeZonas(EdifEstruc edifEstruc) {
		this.edifEstrucDao.removeZonas(edifEstruc);
	}
}
