package com.ejie.aa20b.service;

import com.ejie.aa20b.dao.DireccionesDao;
import com.ejie.x38.dto.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa20b.model.Direcciones;

/**
 * DireccionesServiceImpl generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

@Service(value = "direccionesService")
public class DireccionesServiceImpl implements DireccionesService {

	@Autowired
	private DireccionesDao direccionesDao;

	/**
	 * Inserts a single row in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @return Direcciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Direcciones add(Direcciones direcciones) {
		return this.direccionesDao.add(direcciones);
	}

	/**
	 * Updates a single row in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @return Direcciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Direcciones update(Direcciones direcciones) {
		return this.direccionesDao.update(direcciones);
	}

	/**
	 * Dar de baja la Direccion.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @return Direcciones
	 */
	@Transactional(rollbackFor = Throwable.class)
	public Direcciones darBajaDirecc(Direcciones direcciones) {
		return this.direccionesDao.darBajaDirecc(direcciones);
	}

	/**
	 * Finds a single row in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @return Direcciones
	 */
	public Direcciones find(Direcciones direcciones) {
		return (Direcciones) this.direccionesDao.find(direcciones);
	}

	/**
	 * Finds a List of rows in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Direcciones> findAll(Direcciones direcciones,
			Pagination pagination) {
		return (List<Direcciones>) this.direccionesDao.findAll(direcciones,
				pagination);
	}

	public List<Direcciones> findAllCargaGmao(Direcciones direcciones,
			Pagination pagination) {
		return (List<Direcciones>) this.direccionesDao.findAllCargaGmao(
				direcciones, pagination);
	}

	/**
	 * Finds a List of rows in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	public List<Direcciones> findAllFormateado(Direcciones direcciones,
			Pagination pagination) {
		return (List<Direcciones>) this.direccionesDao.findAllFormateado(
				direcciones, pagination);
	}

	/**
	 * Counts rows in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @return Long
	 */
	public Long findAllCount(Direcciones direcciones) {
		return this.direccionesDao.findAllCount(direcciones);
	}

	/**
	 * Finds rows in the Direcciones table using like.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	public List<Direcciones> findAllLike(Direcciones direcciones,
			Pagination pagination, Boolean startsWith) {
		return (List<Direcciones>) this.direccionesDao.findAllLike(direcciones,
				pagination, startsWith);
	}

	/**
	 * Counts rows in the Direcciones table using like.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	public Long findAllLikeCount(Direcciones direcciones, Boolean startsWith) {
		return this.direccionesDao.findAllLikeCount(direcciones, startsWith);
	}

	/**
	 * Deletes a single row in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(Direcciones direcciones) {
		this.direccionesDao.remove(direcciones);
	}

	/**
	 * Deletes multiple rows in the Direcciones table.
	 * 
	 * @param direccionesList
	 *            List
	 * @return
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void removeMultiple(List<Direcciones> direccionesList) {
		for (Direcciones direccionesAux : direccionesList) {
			this.direccionesDao.remove(direccionesAux);
		}
	}

	/**
	 * Si no existe la Direccion la da de alta.
	 * 
	 * @param direccion
	 *            String
	 * @return Boolean
	 */
	public Boolean altaExisteDireccion(Direcciones direccion) {
		return this.direccionesDao.altaExisteDireccion(direccion);
	}

	/**
	 * Obtener Direccinoes asociadas a un Dpto (por cidepar).
	 * 
	 * @param cidepar
	 *            String
	 * @return List
	 */
	public List<Direcciones> obtenerDireccionesDpto(String cidepar) {
		return this.direccionesDao.obtenerDireccionesDpto(cidepar);
	}
}
