package com.ejie.aa20b.service;

import com.ejie.x38.dto.Pagination;
import java.util.List;

import com.ejie.aa20b.model.Direcciones;

/**
 * DireccionesService generated by UDA, 28-nov-2014 11:32:16.
 * 
 * @author UDA
 */

public interface DireccionesService {

	/**
	 * Inserts a single row in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @return Direcciones
	 */
	Direcciones add(Direcciones direcciones);

	/**
	 * Updates a single row in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @return Direcciones
	 */
	Direcciones update(Direcciones direcciones);

	/**
	 * Dar de baja la Direccion.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @return Direcciones
	 */
	Direcciones darBajaDirecc(Direcciones direcciones);

	/**
	 * Finds a single row in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @return Direcciones
	 */
	Direcciones find(Direcciones direcciones);

	/**
	 * Finds a List of rows in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Direcciones> findAll(Direcciones direcciones, Pagination pagination);

	List<Direcciones> findAllCargaGmao(Direcciones direcciones,
			Pagination pagination);

	/**
	 * Finds a List of rows in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @param pagination
	 *            Pagination
	 * @return List
	 */
	List<Direcciones> findAllFormateado(Direcciones direcciones,
			Pagination pagination);

	/**
	 * Counts rows in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @return Long
	 */
	Long findAllCount(Direcciones direcciones);

	/**
	 * Finds rows in the Direcciones table using like.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @param pagination
	 *            Pagination
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Direcciones> findAllLike(Direcciones direcciones,
			Pagination pagination, Boolean startsWith);

	/**
	 * Counts rows in the Direcciones table using like.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Direcciones direcciones, Boolean startsWith);

	/**
	 * Deletes a single row in the Direcciones table.
	 * 
	 * @param direcciones
	 *            Direcciones
	 * @return
	 */
	void remove(Direcciones direcciones);

	/**
	 * Deletes multiple rows in the Direcciones table.
	 * 
	 * @param direccionesList
	 *            List
	 * @return
	 */
	void removeMultiple(List<Direcciones> direccionesList);

	/**
	 * Si no existe la Direcciones la da de alta.
	 * 
	 * @param direccion
	 *            Direcciones
	 * @return Boolean
	 */
	public Boolean altaExisteDireccion(Direcciones direccion);

	/**
	 * Obtener Direccinoes asociadas a un Dpto (por cidepar).
	 * 
	 * @param codpto
	 *            String
	 * @return List
	 */
	List<Direcciones> obtenerDireccionesDpto(String cidepar);

}
